<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

JHtml::_('jquery.framework');

$doc->addStyleSheet(JUri::base(true) . '/modules/mod_vp_ajax_search/assets/css/module.css?ver=1.2');
$doc->addScript(JUri::base(true) . '/modules/mod_vp_ajax_search/assets/js/ajaxsearch.min.js?ver=1.2');

$doc->addStyleDeclaration("
.vpajaxsearch-suggestion {
	width: {$width_desktop}%;
}
@media (min-width: 992px) and (max-width: 1200px) {
	.vpajaxsearch-suggestion {
		width: {$width_sm_desktop}%;
	}
}
@media(min-width: 768px) and (max-width: 991px) {
	.vpajaxsearch-suggestion {
		width: {$width_tablet}%;
	}
}
@media(max-width: 767px) {
	.vpajaxsearch-suggestion {
		width: {$width_mobile}%;
	}
}
");
?>
<div class="search<?php echo $moduleclass_sfx ?>">
	<form action="<?php echo $action_url ?>" data-action="<?php echo $ajax_action_url ?>" class="vpajaxsearch-line-loader" method="get" data-searchform>
		<?php if($show_loader) : ?>
			<div class="vpajaxsearch-loader-wrapper"><div class="vpajaxsearch-loader"></div></div>
		<?php endif; ?>
		<?php if (!empty($label)) : ?>
			<label for="mod-vp-ajax-search-searchword" class="sr-only"><?php echo $label ?></label>
		<?php endif; ?>
		<input type="search" name="keyword" id="mod-vp-ajax-search-searchword" class="form-control search-query input-lg" value="" placeholder="<?php echo $text ?>" autocomplete="off" data-ajaxsearch="true" data-foundtext="<?php echo $found_text ?>" data-viewalltext="<?php echo $viewall_text ?>" data-limit="<?php echo $limit ?>" data-catid="<?php echo $category_id ?>" data-minchars="<?php echo $min_characters ?>" />
		<?php foreach($hidden_fields as $name => $value) : ?>
			<input type="hidden" name="<?php echo $name ?>" value="<?php echo $value ?>" />
		<?php endforeach; ?>
	</form>
</div>