<?php 
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

$template_params = plgSystemVPFrameworkHelper::getTemplate()->params;
$theme           = !empty($theme) ? $theme : 'carousel-nav-top';
?>
<div class="vp-product-carousel<?php echo $params->get('moduleclass_sfx') ?><?php echo $params->get('enabled_equal_height', 1) ? ' equal-height' : ''; ?><?php echo ($lazyLoad == 'true') ? ' lazyload-enabled' : ''; ?>">
	<div id="<?php echo $module_id ?>" class="vp-product-carousel-inner owl-carousel <?php echo $theme ?><?php echo $params->get('navigation', 1) ? ' navigation-enabled' : ''; ?>">
		<?php foreach($products as $product) : ?>
			<?php
			$productLink = empty($product->link) ? $product->canonical : $product->link;
			$Itemid      = VPFrameworkVM::getMenuId($productLink);
			$ItemidStr   = !empty($Itemid) ? '&Itemid=' . $Itemid : '';
			$productLink = JRoute::_($productLink . $ItemidStr);
			?>
			<div class="product product-item">
				<a href="<?php echo $productLink; ?>">
					<?php echo shopFunctionsF::renderVmSubLayout('tags', array('product' => $product)); ?>
				</a>
				<div class="product-inner">
					<div class="product-image-cont">
						<a href="<?php echo $productLink; ?>" title="<?php echo $product->product_name ?>">
							<?php if ($lazyLoad == 'true')
							{
								echo VPFrameworkVM::displayThumnbailLazily($product->images[0], $product->product_name, 'lazyOwl img-responsive', false, 'data-src');
							}
							else
							{
								echo $product->images[0]->displayMediaThumb('class="img-responsive"', false);
							} ?>
						</a>
						<?php echo shopFunctionsF::renderVmSubLayout('productextras', array('product' => $product, 'showAddToCartHover' => ($show_addtocart && $show_addtocart == 2))); ?>
					</div>
					<div class="product-name-cont">
						<h2 class="product-name">
							<a href="<?php echo $productLink; ?>" title="<?php echo $product->product_name ?>" class="hover-invert"><?php echo $product->product_name ?></a>
						</h2>
					</div>
					<?php if($template_params->get('show_vm_list_category_name', 1) && !empty($product->category_name)) : ?>
						<div class="product-cat-name-cont">
							<span class="text-muted category-name"><?php echo $product->category_name; ?></span>
						</div>
					<?php endif; ?>
					<?php if($showRating && !empty($product->rating)) : ?>
						<div class="product-rating-cont<?php echo ($showRating == 2) ? ' display-on-mouseover' : ''; ?>">
							<?php require JModuleHelper::getLayoutPath('mod_vp_product_carousel', $params->get('layout', 'default') . '_rating'); ?>
						</div>
					<?php endif; ?>
					<?php if($show_price) : ?>
						<div class="product-price-cont">
							<?php require JModuleHelper::getLayoutPath('mod_vp_product_carousel', $params->get('layout', 'default') . '_price'); ?>
						</div>
					<?php endif; ?>
					<?php if($show_addtocart) : ?>
						<div class="product-addtocart-cont<?php echo ($show_addtocart == 2) ? ' hide' : ''; ?>">
							<?php require JModuleHelper::getLayoutPath('mod_vp_product_carousel', $params->get('layout', 'default') . '_addtocart'); ?>
						</div>
					<?php endif; ?>
				</div>
			</div>
		<?php endforeach; ?>
	</div>
</div>