<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

$body_script = $params->get('body_script', '');
$body_script = trim(preg_replace('/<script[^>]*?>.*?><\/script>/is', '$1', $body_script));
?>
<!DOCTYPE html>
<html lang="<?php echo $this->language; ?>" dir="<?php echo $this->direction; ?>" class="<?php echo $htmlClass ?>">
<?php require $template->loadBlock('head.fee'); ?>

<body>
	<div class="vpf-wrapper">
		<?php require $template->loadBlock('header.fee'); ?>
		<?php require $template->loadBlock('mainbody.fee'); ?>
		<?php require $template->loadBlock('footer.fee'); ?>
		<?php if($this->params->get('show_scroll_to_top', 1)) : ?>
			<button type="button" class="vpf-scroll-top-button" data-scroll="top" title="<?php echo JText::_('PLG_SYSTEM_VPFRAMEWORK_SCROLL_TOP_TOP') ?>">
				<span class="sr-only element-invisible"><?php echo JText::_('PLG_SYSTEM_VPFRAMEWORK_SCROLL_TOP_TOP') ?></span><i class="icon-uparrow"></i>
			</button>
		<?php endif; ?>
	</div>
	<jdoc:include type="modules" name="debug" style="none" />
	
  <?php if(!empty($body_script)) : ?>
  <script type="text/javascript">
    <?php echo $body_script . PHP_EOL ?>
  </script>
  <?php endif; ?>

</body>
</html>