<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

// Note. It is important to remove spaces between elements.
$title      = $item->anchor_title ? ' title="' . $item->anchor_title . '" ' : '';
$itemParams = method_exists($item, 'getParams') ? $item->getParams() : $item->params;
$linktype   = '';

if($item->icon_class)
{
	$linktype .= '<i class="offcanvas-icon ' . $item->icon_class . '"></i>';
}

if ($item->menu_image)
	{
		$itemParams->get('menu_text', 1) ?
		$linktype .= '<img src="' . $item->menu_image . '" alt="' . $item->title . '" /><span class="image-title">' . $item->title . '</span> ' :
		$linktype .= '<img src="' . $item->menu_image . '" alt="' . $item->title . '" />';
}
else
{
	$linktype .= $item->title;
}

if($item->deeper)
{
	$linktype .= '<span class="opener"></span>';
}
?>
<span class="separator"<?php echo $title; ?>>
	<?php echo $linktype; ?>
</span>
