/**
 * @author Sakis Terzis
 * @license GNU/GPL v.2
 * @copyright Copyright (C) 2013 breakDesigns.net. All rights reserved
 */

window.addEventListener('DOMContentLoaded', function(event) {
	let displayTypesDropDowns = document.querySelectorAll('.cfDisplayTypes');

	displayTypesDropDowns.forEach(function (displayTypesDropDown){
		displayTypesDropDown.addEventListener('change', function() {
			let dropdown_id = this.getAttribute('id');
			let filterid = dropdown_id.substring(7);
			showSettingsByDisplayType(filterid);
		});
	});

	if (document.getElementById('cfOptimizerForm') != null) {
		document.getElementById('cfOptimizerForm').addEventListener('submit', function(e) {
			e.preventDefault();
			const url = `index.php?option=com_customfilters&task=optimizer.optimize&format=json`;
			const target=document.getElementById('optimizer_results');
			const data = {
				[this._csrfToken]: '1',
			};

			Joomla.request({
				url,
				method : 'POST',
				data: data,
				headers: {
					'Content-Type': 'application/json'
				},
				onBefore : function() {
					target.classList.add('cf_spinner');
				},
				onSuccess : function(response) {
					setInterval(function(){displayResults(JSON.parse(response), target);},2000);

				},
				onError: function(xhr) {
					console.error('Error Calling the Optimizer');
					reject(xhr);
				}
			});
		});
	}

	/**
	 * Display the results of the optimizer
	 * @since 1.9.5
	 * @author Sakis Terz
	 */
	function displayResults(response,target){
		let found=response.found.length;
		let notFound=response.Notfound.length;
		let added=response.added.length;
		let success=response.success;
		let html='<div class="cf_log_wrapper">';
		if (success!=-1){
			html+='<span class="msg_neutral">Indexes Found: '+found+'</span><br/>';
			html+='<span class="msg_division">'+added+'/'+notFound+' Indexes Added.</span> <br/><span class="msg_precentage">Success: '+parseInt(success)*100+'%</span>';
		}else {
			html+='<span class="msg_neutral">No missing indexes found. No action required</span>';
		}
		html+='</div>';
		target.classList.remove('cf_spinner');
		target.innerHTML=html;
	}
})