<?php
/**
 * @package    customfilters
 * @author        Sakis Terz
 * @link        http://breakdesigns.net
 * @copyright    Copyright (c) 2012-2022 breakdesigns.net. All rights reserved.
 * @license        See LICENSE.txt
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\MVC\Controller\AdminController;
use Joomla\Utilities\ArrayHelper;
use Joomla\CMS\Factory;
use Joomla\Registry\Registry;
use Joomla\CMS\Language\Text;

/**
 * main controller class
 *
 * @since 1.0
 * @author Sakis Terz
 * @package customfilters
 */
class CustomfiltersControllerCustomfilters extends AdminController
{

    /**
     * Save Filters task
     *
     *
     * @return void
     * @since 1.0
     * @author Sakis Terz
     */
    public function savefilters()
    {
        $app = Factory::getApplication();
        $user = $app->getIdentity();

        if ($user->authorise('core.edit', 'com_customfilters')) {
            // display types which have advanced settings
            $adv_setting_types = [
                '5',
                '6',
                '5,6',
                '8'
            ];

            $model = $this->getModel();
            $jinput = $app->input;
            $type_ids = $jinput->get('type_id', [], 'array');
            $alias = $jinput->get('alias', [], 'array');
            $smart_search = $jinput->get('smart_search', [], 'array');
            $expanded = $jinput->get('expanded', [], 'array');
            $scrollbar_after = $jinput->get('scrollbar_after', [], 'array');
            $slider_min_value = $jinput->get('slider_min_value', [], 'array');
            $slider_max_value = $jinput->get('slider_max_value', [], 'array');
            $filter_category_ids = $jinput->get('filter_categories', [], 'array');
            // Display if selected setting display_if_filter_exist
            $display_if_filter_exist = $jinput->get('display_if_filter_exist', [], 'array');
            $conditional_operator = $jinput->get('conditional_operator', [], 'array');
            $show_more_after = $jinput->get('show_more_after', [], 'array');

            // SEO settings
            $update_page_title = $jinput->get('update_page_title', [], 'array');
            $update_page_heading = $jinput->get('update_page_heading', [], 'array');
            $treat_as_unique_page = $jinput->get('treat_as_unique_page', [], 'array');

            $params_array = [];
            array_walk($type_ids, function (&$value, $key) {
                $value = (string)$value;
            });
            $show_more_after = ArrayHelper::toInteger($show_more_after);
            $smart_search = ArrayHelper::toInteger($smart_search);
            $expanded = ArrayHelper::toInteger($expanded);
            $slider_min_value = ArrayHelper::toInteger($slider_min_value);
            $slider_max_value = ArrayHelper::toInteger($slider_max_value);
            $update_page_title = ArrayHelper::toInteger($update_page_title);
            $update_page_heading = ArrayHelper::toInteger($update_page_heading);
            $treat_as_unique_page = ArrayHelper::toInteger($treat_as_unique_page);

            array_walk($alias, function (&$value, $key) {
                $value = (string)$value;
            });
            array_walk($scrollbar_after, function (&$value, $key) {
                $value = (string)$value;
            });

            // store the params in an assoc array and use the item id as key
            foreach ($smart_search as $key => $val) {
                $params_array[$key] = array(
                    'smart_search' => $val,
                    'expanded' => $expanded[$key],
                    'scrollbar_after' => $scrollbar_after[$key],
                    'show_more_after' => $show_more_after[$key],
                    'display_if_filter_exist' => !empty($display_if_filter_exist[$key]) ? $display_if_filter_exist[$key] : '',
                    // Sanitize the operator. Can be 'AND' or 'OR'
                    'conditional_operator' => !empty($conditional_operator[$key]) && in_array($conditional_operator[$key],
                        ['AND', 'OR']) ? strtoupper($conditional_operator[$key]) : 'AND',
                    'update_page_title'    => $update_page_title[$key] ?? 0,
                    'update_page_heading'  => $update_page_heading[$key] ?? 0,
                    'treat_as_unique_page' => $treat_as_unique_page[$key] ?? 0,
                );
                if (in_array($type_ids[$key], $adv_setting_types)) {
                    if ($type_ids[$key] == '6' || $type_ids[$key] == '5,6') { // slider
                        $params_array[$key]['slider_min_value'] = $slider_min_value[$key];
                        $params_array[$key]['slider_max_value'] = $slider_max_value[$key];
                    }
                    $params_array[$key]['filter_category_ids'] = !empty($filter_category_ids[$key]) ? $filter_category_ids[$key] : '';
                }
            }

            $params_formated = $this->formatParams($params_array);
            // sanitize the input to be int

            if ($type_ids || $alias || $params_formated) {
                if (!$model->savefilters($type_ids, $alias, $params_formated)) {
                    throw new \Exception($model->getError(), 500);
                } else {
                    $this->setMessage(Text::_('COM_CUSTOMFILTERS_FILTERS_SAVED_SUCCESS'));
                }
            }
        }
        $this->setRedirect('index.php?option=com_customfilters&view=customfilters');
    }

    /**
     * Proxy for getModel.
     *
     * @param string $name
     *            of the model.
     * @param string $prefix
     *            for the PHP class name.
     *
     * @return Joomla\CMS\MVC\Model\AdminModel
     * @since 1.0
     */
    public function getModel(
        $name = 'Customfilter',
        $prefix = 'CustomfiltersModel',
        $config = array('ignore_request' => true)
    ) {
        $model = parent::getModel($name, $prefix, $config);
        return $model;
    }

    /**
     * Create an array with the params as json string
     *
     * @return array
     * @since 1.5.3
     * @author Sakis Terz
     */
    public function formatParams($params_array)
    {
        $params_array_formated = [];

        foreach ($params_array as $key => $array) {
            $reg = new Registry();
            $reg->loadArray($array);
            $params_array_formated[$key] = $reg->toString();
        }
        return $params_array_formated;
    }
}
