
<?php
/**
 *
 * Customfilters entry point
 *
 * @package		customfilters
 * @author		Sakis Terz
 * @link		http://breakdesigns.net
 * @copyright	Copyright (c) 2012-2022 breakdesigns.net. All rights reserved.
 * @license		http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 *				customfilters is free software. This version may have been modified
 *				pursuant to the GNU General Public License, and as distributed
 *				it includes or is derivative of works licensed under the GNU
 *				General Public License or other free or open source software
 *				licenses.
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\MVC\Controller\BaseController;

// Access check.
if (!Factory::getApplication()->getIdentity()->authorise('core.manage', 'com_customfilters')) {
	throw new \Exception(Text::_('JERROR_ALERTNOAUTHOR'));
}

if (!class_exists( 'VmConfig' )) {
	$vmconfigPath = JPATH_ADMINISTRATOR . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . 'com_virtuemart'.DIRECTORY_SEPARATOR.'helpers'.DIRECTORY_SEPARATOR.'config.php';
	if(!file_exists($vmconfigPath)) {
		throw new \RuntimeException('Virtuemart is not installed or it\'s files are not accessible');
	}
	require($vmconfigPath);
}

VmConfig::loadConfig();
if (!class_exists( 'cfHelper' )) {
	require(JPATH_ADMINISTRATOR . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . 'com_customfilters'.DIRECTORY_SEPARATOR.'helpers'.DIRECTORY_SEPARATOR.'cfhelper.php');
}
if (!class_exists( 'VmCompatibility' )) {
	require(JPATH_ADMINISTRATOR . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . 'com_customfilters'.DIRECTORY_SEPARATOR.'helpers'.DIRECTORY_SEPARATOR.'vmcompatibility.php');
}

// We have to keep that in J4 as well, since we do not declare a namespace for the component that will be B/C breaker.
JLoader::register('Breakdesigns\Customfilters\Admin\Model\UpdateManager',
    dirname(__FILE__).DIRECTORY_SEPARATOR . 'models'.DIRECTORY_SEPARATOR.'UpdateManager.php');

// Add stylesheets and Scripts
$document = Factory::getApplication()->getDocument();
$document->addStyleSheet(Uri::root().'administrator/components/com_customfilters/assets/css/display.css');

$input= Factory::getApplication()->input;
$controller = BaseController::getInstance('customfilters');
$controller->execute($input->get('task','display','cmd'));
$controller->redirect();
