<?php
/**
 *
 * The file for the advanced setting
 *
 * @package        customfilters
 * @since          1.8.0
 * @copyright      Copyright (c) 2012-2022 breakdesigns.net. All rights reserved.
 * @license        http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 *                 customfilters is free software. This version may have been modified
 *                 pursuant to the GNU General Public License, and as distributed
 *                 it includes or is derivative of works licensed under the GNU
 *                 General Public License or other free or open source software
 *                 licenses.
 * @link           http://breakdesigns.net
 * @author         Sakis Terz
 */

defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Layout\LayoutHelper;

// J3 uses a different HTMLHelper key for the tabs than J4
$tabsKey = 'uitab';
if (version_compare(JVERSION, '4.0.0', 'lt')) {
    $tabsKey = 'bootstrap';
}

/*
 * The class name of each li indicates for each display type should be displayed
 * e.g. class:setting6 will be displayed for the display type 6 (range slider), setting5 for range inputs
 */
?>

<div class="bdpopup cf_advacned_settings cfhide" id="window<?php
echo $item->id ?>">
    <a id="hide_popup<?php
    echo $item->id ?>" class="hide_popup" aria-label="<?php
    echo Text::_('JLIB_HTML_BEHAVIOR_CLOSE') ?>"></a>

    <h3><?php echo Text::_('COM_CUSTOMFILTERS_ADV_SETTINGS'); ?></h3>
    <div class="adminformlist">
        <?php
        echo HTMLHelper::_($tabsKey . '.startTabSet', 'myTab' . $item->id,
            ['active' => 'general' . $item->id, 'recall' => true, 'breakpoint' => 768]); ?>

        <?php
        echo HTMLHelper::_($tabsKey . '.addTab', 'myTab' . $item->id, 'general' . $item->id, Text::_('COM_CUSTOMFILTERS_ADV_SETTINGS_GENERAL')); ?>
        <div class="cf_setings_container">
            <?php
            if ($item->data_type == 'float' || $item->data_type == 'int' || $item->data_type == 'date') {
                if (count($item->filter_category_ids) > 0) {
                    $categoryTree = cfHelper::categoryListTree($item->filter_category_ids);
                } else {
                    $categoryTree = cfHelper::categoryListTree();
                }
                ?>
                <?php
                if ($item->data_type == 'float' || $item->data_type == 'int') { ?>
                    <div class="setting6 control-group">
                        <div class="control-label">
                            <label class="cflabel" for="slider_min_value_<?php
                            echo $item->id ?>"><?php
                                echo Text::_('COM_CUSTOMFILTERS_SLIDER_MIN_VALUE_LABEL'); ?>
                            </label>
                        </div>
                        <div class="controls">
                            <input type="text"
                                   name="slider_min_value[<?php
                                   echo $item->id ?>]"
                                   id="slider_min_value_<?php
                                   echo $item->id ?>"
                                   value="<?php
                                   echo $item->slider_min_value ?>" class="inputbox"
                                   size="4" maxlength="8"/>
                        </div>
                    </div>

                    <div class="setting6 control-group">
                        <div class="control-label">
                            <label class="cflabel" for="slider_max_value_<?php
                            echo $item->id ?>"><?php
                                echo Text::_('COM_CUSTOMFILTERS_SLIDER_MAX_VALUE_LABEL'); ?>
                            </label>
                        </div>
                        <div class="controls">
                            <input type="text"
                                   name="slider_max_value[<?php
                                   echo $item->id ?>]"
                                   id="slider_max_value_<?php
                                   echo $item->id ?>"
                                   value="<?php
                                   echo $item->slider_max_value ?>" class="inputbox"
                                   size="4" maxlength="8"/>
                        </div>
                    </div>
                    <?php
                } ?>

                <div class="setting5 setting6 setting8 control-group">
                    <div class="control-label">
                        <label class="cflabel" for="categories_<?php
                        echo $item->id ?>"><?php
                            echo Text::_('COM_CUSTOMFILTERS_FILTER_TO_CATEGORIES'); ?>
                        </label>
                    </div>
                    <div class="controls">
                        <select class="cf-choosen-select"
                                data-placeholder="<?php
                                echo Text::_('JOPTION_ALL_CATEGORIES'); ?>"
                                id="categories_<?php
                                echo $item->id ?>"
                                name="filter_categories[<?php
                                echo $item->id ?>][]"
                                multiple="multiple">
                            <?php
                            echo $categoryTree; ?>
                        </select>
                    </div>
                </div>
                <?php
            } ?>

            <div class="setting2 setting3 setting4 setting9 setting10 setting11 setting12 control-group">
                <div class="control-label">
                    <label class="cflabel" for="show_more_after_<?php echo $item->id ?>">
                        <?php echo Text::_('COM_CUSTOMFILTERS_SHOW_MORE_AFTER'); ?>
                    </label>
                </div>
                <div class="controls">
                    <input type="number" name="show_more_after[<?php
                    echo $item->id ?>]" id="show_more_after_<?php
                    echo $item->id ?>" class="inputbox" value="<?php
                    echo $item->show_more_after ?>"/>
                </div>
            </div>

            <div class="setting2 setting3 setting4 setting9 setting10 setting11 setting12 control-group">
                <div class="control-label">
                    <label class="cflabel" for="scrollbar_after_<?php echo $item->id ?>">
                        <?php echo Text::_('COM_CUSTOMFILTERS_SCROLLBARAFTER'); ?>
                    </label>
                </div>
                <div class="controls">
                    <input type="text" name="scrollbar_after[<?php echo $item->id ?>]"
                           id="scrollbar_after_<?php echo $item->id ?>" class="inputbox"
                           size="5" maxlength="10" pattern="[\d.]+(px|em|rem|vw|vh|vmin|vmax|ex|cm|mm|pt|in|%){1}"
                           value="<?php echo $item->scrollbar_after ?>"/>
                </div>
            </div>

            <?php
            $customFiltersOptions = cfHelper::getCustomFiltersOptions($item->vm_custom_id,
                $item->display_if_filter_exist); ?>
            <div class="control-group">
                <div class="control-label">
                    <label class="cflabel" for="customfilters_<?php
                    echo $item->id ?>"><?php
                        echo Text::_('COM_CUSTOMFILTERS_DISPLAY_IF_SELECTED'); ?>
                    </label>
                </div>
                <div class="controls">
                    <select class="cf-choosen-select"
                            data-placeholder="<?php
                            echo Text::_('COM_CUSTOMFILTERS'); ?>"
                            id="customfilters_<?php
                            echo $item->id ?>"
                            name="display_if_filter_exist[<?php
                            echo $item->id ?>][]"
                            multiple="multiple">
                        <?php
                        echo implode('', $customFiltersOptions); ?>
                    </select>
                </div>
            </div>

            <div class="control-group">
                <div class="control-label">
                    <label class="cflabel"
                           for="conditional_operator_<?php
                           echo $item->id ?>"><?php
                        echo Text::_('COM_CUSTOMFILTERS_CONDITIONAL_OPERATOR'); ?>
                    </label>
                </div>
                <div class="controls">
                    <select id="conditional_operator_<?php echo $item->id ?>"
                            class="form-select"
                            name="conditional_operator[<?php
                            echo $item->id ?>]">
                        <option value="AND" <?php
                        echo $item->conditional_operator == 'AND' ? 'selected' : '' ?>><?php
                            echo Text::_('COM_CUSTOMFILTERS_OPERATOR_AND') ?></option>
                        <option value="OR" <?php
                        echo $item->conditional_operator == 'OR' ? 'selected' : '' ?>><?php
                            echo Text::_('COM_CUSTOMFILTERS_OPERATOR_OR') ?></option>
                    </select>
                </div>
            </div>
        </div>
        <?php
        echo HTMLHelper::_($tabsKey . '.endTab'); ?>
        <?php
        echo HTMLHelper::_($tabsKey . '.addTab', 'myTab' . $item->id, 'seo' . $item->id, Text::_('COM_CUSTOMFILTERS_ADV_SETTINGS_SEO')); ?>
        <div class="cf_setings_container">
            <div class="control-group">
                <div class="control-label">
                    <label class="cflabel" for="update_page_title_<?php echo $item->id ?>">
                        <?php echo Text::_('COM_CUSTOMFILTERS_FILTER_UPDATE_PAGE_TITLE'); ?>
                    </label>
                </div>
                <div class="controls">
                    <?php
                    $option0 = new \stdClass();
                    $option0->value = '0';
                    $option0->text = Text::_('JNO');

                    $option1 = new \stdClass();
                    $option1->value = '1';
                    $option1->text = Text::_('JYES');

                    $displayData = [
                        'id' => 'update_page_title_' . $item->id,
                        'class' => 'update_page_title_radio',
                        'label' => Text::_('COM_CUSTOMFILTERS_FILTER_UPDATE_PAGE_TITLE'),
                        'name' => 'update_page_title[' . $item->id . ']',
                        'value' => isset($item->update_page_title) ? (string)$item->update_page_title : '0',
                        'disabled' => false,
                        'readonly' => false,
                        'required' => false,
                        'autofocus' => false,
                        'dataAttribute' => '',
                        'onchange' => '',
                        'options' => [
                            $option0,
                            $option1
                        ]
                    ];
                    echo LayoutHelper::render('joomla.form.field.radio.switcher', $displayData); ?>
                </div>
            </div>

            <div class="control-group">
                <div class="control-label">
                    <label class="cflabel" for="update_page_heading_<?php echo $item->id ?>">
                        <?php echo Text::_('COM_CUSTOMFILTERS_FILTER_UPDATE_PAGE_HEADING'); ?>
                    </label>
                </div>
                <div class="controls">
                    <?php
                    $option0 = new \stdClass();
                    $option0->value = '0';
                    $option0->text = Text::_('JNO');

                    $option1 = new \stdClass();
                    $option1->value = '1';
                    $option1->text = Text::_('JYES');

                    $displayData = [
                        'id' => 'update_page_heading_' . $item->id,
                        'class' => 'update_page_heading_radio',
                        'label' => Text::_('COM_CUSTOMFILTERS_FILTER_UPDATE_PAGE_HEADING'),
                        'name' => 'update_page_heading[' . $item->id . ']',
                        'value' => isset($item->update_page_heading) ? (string)$item->update_page_heading : '0',
                        'disabled' => false,
                        'readonly' => false,
                        'required' => false,
                        'autofocus' => false,
                        'dataAttribute' => '',
                        'onchange' => '',
                        'options' => [
                            $option0,
                            $option1
                        ]
                    ];
                    echo LayoutHelper::render('joomla.form.field.radio.switcher', $displayData); ?>
                </div>
            </div>

            <div class="control-group">
                <div class="control-label">
                    <label class="cflabel" for="treat_as_unique_page_<?php echo $item->id ?>">
                        <?php echo Text::_('COM_CUSTOMFILTERS_FILTER_TREAT_AS_UNIQUE'); ?>
                    </label>
                </div>
                <div class="controls">
                    <?php
                    $option0 = new \stdClass();
                    $option0->value = '0';
                    $option0->text = Text::_('JNO');

                    $option1 = new \stdClass();
                    $option1->value = '1';
                    $option1->text = Text::_('JYES');

                    $displayData = [
                        'id' => 'treat_as_unique_page_' . $item->id,
                        'class' => 'treat_as_unique_page_radio',
                        'label' => Text::_('COM_CUSTOMFILTERS_FILTER_TREAT_AS_UNIQUE'),
                        'name' => 'treat_as_unique_page[' . $item->id . ']',
                        'value' => isset($item->treat_as_unique_page) ? (string)$item->treat_as_unique_page : '0',
                        'disabled' => false,
                        'readonly' => false,
                        'required' => false,
                        'autofocus' => false,
                        'dataAttribute' => '',
                        'onchange' => '',
                        'options' => [
                            $option0,
                            $option1
                        ]
                    ];
                    echo LayoutHelper::render('joomla.form.field.radio.switcher', $displayData); ?>
                    <div>
                        <small class="form-text"><?= Text::_('COM_CUSTOMFILTERS_FILTER_TREAT_AS_UNIQUE_DESC')?></small>
                    </div>
                </div>
            </div>
        </div>
        <?php
        echo HTMLHelper::_($tabsKey . '.endTab'); ?>
        <?php
        echo HTMLHelper::_($tabsKey . '.endTabSet'); ?>
        <div class="control-group text-center actions-container">
            <button class="btn btn-block btn-primary bdokbutton w-100" id="close_btn<?php
            echo $item->id ?>" onclick="return false;">OK
            </button>
        </div>
    </div>

</div>
<script type="text/javascript">displayPopup(<?php echo $item->id?>);</script>

