<?php
/***
 * @package   customfilters
 * @copyright Copyright (C) 2012-2022 breakdesigns.net . All rights reserved.
 * @license   GNU General Public License version 2 or later; see LICENSE.txt
 * @author    Sakis Terz
 */

use Joomla\CMS\Factory;

/**
 * This handles a Collection of CustomFieldHelper objects
 * @since 2.15.0
 */
class CustomFieldsHelper
{
    /**
     * @var CustomFieldsHelper
     * @since 2.15.0
     */
    protected static $instance;

	/**
	 * The CustomFieldHelper array
	 *
	 * @var array
	 * @since 2.15.0
	 */
    protected $customFields = [];

	/**
	 * Get instance
	 *
	 * @return CustomFieldsHelper
	 *
	 * @since 2.15.0
	 */
    public static function getInstance()
    {
        if (!isset(self::$instance)) {
            self::$instance = new CustomFieldsHelper();
        }

        return self::$instance;
    }

    /**
     * Get the CustomFieldHelper by the custom field id
     *
     * @param   int  $customFieldId
     *
     * @return CustomFieldHelper|mixed
     * @since 2.15.0
     */
    public function getCustomField(int $customFieldId)
    {
        $customFilters = cftools::getCustomFilters();
        $customFilter = $customFilters[$customFieldId] ?? null;

        if(!isset($customFilter)) {
           throw new \RuntimeException('No Custom Filter with id:'. $customFieldId);
        }

        if (!isset($this->customFields[$customFieldId])) {
            $this->customFields[$customFieldId] = new CustomFieldHelper($customFilter);
        }

        return $this->customFields[$customFieldId];
    }

	/**
	 * Get a custom filter by its alias
	 *
	 * @param string $alias
	 *
	 * @return false|object
	 *
	 * @since 2.15.0
	 */
	public function getCustomFilterByAlias(string $alias)
	{
		$customFilters = cftools::getCustomFilters();
		foreach ($customFilters as $customFilter) {
			if ($customFilter->alias == $alias) {
				return $customFilter;
			}
		}

		return false;
	}
}