<?php
/**
 * @package     customfilters
 *
 * @copyright   Copyright © 2022 breakdesigns.net. All rights reserved.
 * @license     GNU General Public License 2 or later, see COPYING.txt for license details.
 */

\defined('_JEXEC') or die();

use Joomla\CMS\Component\Router\RouterView;
use Joomla\CMS\Component\Router\Rules\RulesInterface;
use Joomla\CMS\Factory;
use Joomla\Utilities\ArrayHelper;
use Joomla\CMS\Language\Text;

require_once JPATH_SITE. DIRECTORY_SEPARATOR. 'components'.DIRECTORY_SEPARATOR. 'com_customfilters'.DIRECTORY_SEPARATOR.'include'.DIRECTORY_SEPARATOR.'tools.php';
require_once JPATH_SITE. DIRECTORY_SEPARATOR. 'components'.DIRECTORY_SEPARATOR. 'com_customfilters'.DIRECTORY_SEPARATOR.'include'.DIRECTORY_SEPARATOR.'Config.php';
require_once JPATH_SITE. DIRECTORY_SEPARATOR. 'components'.DIRECTORY_SEPARATOR. 'com_customfilters'.DIRECTORY_SEPARATOR.'include'.DIRECTORY_SEPARATOR.'CfItemsHelper.php';
require_once JPATH_SITE. DIRECTORY_SEPARATOR. 'components'.DIRECTORY_SEPARATOR. 'com_customfilters'.DIRECTORY_SEPARATOR.'include'.DIRECTORY_SEPARATOR.'CategoryHelper.php';
require_once JPATH_SITE. DIRECTORY_SEPARATOR. 'components'.DIRECTORY_SEPARATOR. 'com_customfilters'.DIRECTORY_SEPARATOR.'include'.DIRECTORY_SEPARATOR.'ManufacturerHelper.php';
require_once JPATH_SITE. DIRECTORY_SEPARATOR. 'components'.DIRECTORY_SEPARATOR. 'com_customfilters'.DIRECTORY_SEPARATOR.'include'.DIRECTORY_SEPARATOR.'CustomFieldsHelper.php';
require_once JPATH_SITE. DIRECTORY_SEPARATOR. 'components'.DIRECTORY_SEPARATOR. 'com_customfilters'.DIRECTORY_SEPARATOR.'include'.DIRECTORY_SEPARATOR.'CustomFieldHelper.php';


class FilterRules implements RulesInterface
{
    /**
     * Router this rule belongs to
     *
     * @var RouterView
     * @since 2.12.0
     */
    protected $router;

    /**
     * Class constructor.
     *
     * @param   RouterView  $router  Router this rule belongs to
     *
     * @since 2.12.0
     */
    public function __construct(RouterView $router)
    {
        $this->router = $router;
    }

    public function preprocess(&$query)
    {
        // TODO: Implement preprocess() method.
    }

    /**
     * Parse a sef url
     *
     * @param   array  $segments
     * @param   array  $vars
     *
     * @since 2.12.0
     */
    public function parse(&$segments, &$vars)
    {
        $CfRouterHelper = CfRouterHelper::getInstance();
        $siteLang = $CfRouterHelper->getLangPrefix();
        $defaultSiteLang = $CfRouterHelper->getDefaultLangPrefix();

        // Fix the segments
        $total = count($segments);
        for ($i = 0; $i < $total; $i ++) {
            $segments[$i] = preg_replace('/:/', '-', $segments[$i], 1);
        }

        // empty filters strings
        $no_category = urlencode(Text::_('CF_NO_VMCAT'));
        $no_manufacturer = urlencode(Text::_('CF_NO_VMMANUF'));
        $db = Factory::getDbo();

		$segmentsCounter = 0;
        $categories_ar = explode('__or__', $segments[$segmentsCounter]);
        if (count($categories_ar) > 1 || $categories_ar[$segmentsCounter] != $no_category) {
            unset($segments[0]);

            // It's multi-lingual
            if ($CfRouterHelper->getDefaultLang()) {
                // prepare the slugs for the query
                array_walk($categories_ar, function (&$value, $key) {
                    $db = Factory::getDbo();
                    $value = '(lang_def.slug=' . $db->quote($db->escape($value)) . ' OR lang.slug=' . $db->quote($db->escape($value)) . ')';
                });

                $vmcat_where_str = implode(' OR ', $categories_ar);

                if ($vmcat_where_str) {
                    // Add the manuf alias
                    $q = $db->getQuery(true);
                    $q->select("IFNULL(lang.virtuemart_category_id, lang_def.virtuemart_category_id) AS virtuemart_category_id");
                    $q->from('#__virtuemart_categories_' . $defaultSiteLang . ' AS lang_def');
                    $q->leftJoin("#__virtuemart_categories_" . $siteLang . " AS lang ON lang_def.virtuemart_category_id=lang.virtuemart_category_id");
                    $q->where($vmcat_where_str);
                    $db->setQuery($q);
                    $vm_cat_ids = $db->loadColumn();
                    $vars['virtuemart_category_id'] = $vm_cat_ids;
                }
            } else {
                // prepare the slugs for the query
                array_walk($categories_ar, function (&$value, $key) {
                    $db = Factory::getDbo();
                    $value = 'slug=' . $db->quote($db->escape($value));
                });

                $vmcat_where_str = implode(' OR ', $categories_ar);

                if ($vmcat_where_str) {
                    $q = $db->getQuery(true);
                    $q->select('virtuemart_category_id');
                    $q->from('#__virtuemart_categories_' . $siteLang);
                    $q->where($vmcat_where_str);
                    $db->setQuery($q);
                    $vm_cat_ids = $db->loadColumn();
                    $vars['virtuemart_category_id'] = $vm_cat_ids;
                }
            }
        }
	    $segmentsCounter ++;

        if (isset($segments[$segmentsCounter])) {
            $manuf_ar = explode('__or__', $segments[1]);
            if (count($manuf_ar) > 1 || $manuf_ar[0] != $no_manufacturer) {

                // It's multi-lingual
                if ($CfRouterHelper->getDefaultLang()) {
                    // prepare the slugs for the query
                    array_walk($manuf_ar, function (&$value, $key) {
                        $db = Factory::getDbo();
                        $value = '(lang_def.slug=' . $db->quote($db->escape($value)).' OR lang.slug=' . $db->quote($db->escape($value)).')';
                    });

                    $vmmnf_where_str = implode(' OR ', $manuf_ar);

                    if ($vmmnf_where_str) {
                        // Add the manuf alias
                        $q = $db->getQuery(true);
                        $q->select('IFNULL(lang_def.virtuemart_manufacturer_id, lang.virtuemart_manufacturer_id) AS virtuemart_manufacturer_id');
                        $q->from('#__virtuemart_manufacturers_' . $defaultSiteLang.' AS lang_def');
                        $q->leftJoin('#__virtuemart_manufacturers_' . $siteLang.' AS lang ON lang_def.virtuemart_manufacturer_id=lang.virtuemart_manufacturer_id');
                        $q->where($vmmnf_where_str);
                        $db->setQuery($q);
                        $vm_mnf_ids = $db->loadColumn();
                        $vars['virtuemart_manufacturer_id'] = $vm_mnf_ids;
                    }

                } else {

                    // prepare the slugs for the query
                    array_walk($manuf_ar, function (&$value, $key) {
                        $db = Factory::getDbo();
                        $value = 'slug=' . $db->quote($db->escape($value));
                    });

                    $vmmnf_where_str = implode(' OR ', $manuf_ar);

                    if ($vmmnf_where_str) {
                        // Add the manuf alias
                        $q = $db->getQuery(true);
                        $q->select('virtuemart_manufacturer_id');
                        $q->from('#__virtuemart_manufacturers_' . $siteLang);
                        $q->where($vmmnf_where_str);
                        $db->setQuery($q);
                        $vm_mnf_ids = $db->loadColumn();
                        $vars['virtuemart_manufacturer_id'] = $vm_mnf_ids;
                    }
                }

				if ($vm_mnf_ids) {
					unset($segments[$segmentsCounter]);
					$segmentsCounter ++;
				}
            }
        }

		// Check for Custom Filters
	    $componentConfig = CustomfiltersConfig::getInstance();
	    // If SEF urls enabled go on
	    if ($componentConfig->get('sef_urls_for_cf', 1))
	    {
		    $customFieldsHelper = CustomFieldsHelper::getInstance();
		    for ($i = $segmentsCounter; $i < $total; $i++)
		    {
			    $customFilter = $customFieldsHelper->getCustomFilterByAlias($segments[$i]);
			    if ($customFilter)
			    {
				    $filterVarName = 'custom_f_' . $customFilter->custom_id;
				    unset($segments[$i]);
				    $i++;
				    $valuesAliases = explode('__or__', $segments[$i]);
				    $valuesAliases = array_map('urldecode', $valuesAliases);
				    $attribute     = 'name';
				    if ($customFilter->field_type == 'E')
				    {
					    $attribute = 'id';
				    }
				    $values = $customFieldsHelper->getCustomField($customFilter->custom_id)->get($attribute, $valuesAliases, 'alias');

				    $vars[$filterVarName] = cftools::bin2hexArray($values);
				    unset($segments[$i]);
			    }
		    }
	    }
    }

    /**
     * Build a sef url
     *
     * @param   array  $query
     * @param   array  $segments
     *
     * @throws Exception
     * @since  2.12.0
     */
    public function build(&$query, &$segments)
    {
        // Get the menu item belonging to the Itemid that has been found
        $menuItem = $this->router->menu->getItem($query['Itemid']);

        /*
         * Component do not match the menu item
         * or view is not set
         */
        if ($menuItem && ($menuItem->component !== 'com_' . $this->router->getName() || !isset($menuItem->query['view']))) {
            return;
        }

        // first get the filters
        if (!empty($query['virtuemart_category_id']) && is_array($query['virtuemart_category_id'])) {
            $vm_categories = $query['virtuemart_category_id'];
            $vm_categories = ArrayHelper::toInteger($vm_categories);
            $vm_categories = array_filter($vm_categories);
        }
        if (!empty($query['virtuemart_manufacturer_id']) && is_array($query['virtuemart_manufacturer_id'])) {
            $vm_manufacturers = $query['virtuemart_manufacturer_id'];
            $vm_manufacturers = ArrayHelper::toInteger($vm_manufacturers);
            $vm_manufacturers = array_filter($vm_manufacturers);
        }
        // empty filters strings
        $no_category = urlencode(Text::_('CF_NO_VMCAT'));
        $manuf_string = '';
        $categ_string = '';


        // Categories
        if (!empty($vm_categories)) {
            $categoryHelper = CategoryHelper::getInstance();
            $vm_cat_aliases = $categoryHelper->get('alias', $vm_categories);
            if ($vm_cat_aliases) {
                $categ_string = implode('__or__', $vm_cat_aliases);
            } else {
                $categ_string = $no_category;
            }
            unset($query['virtuemart_category_id']);
	        $segments[] = $categ_string;
        }

        // Manufacturers
        if (!empty($vm_manufacturers)) {
            $manufacturerHelper = ManufacturerHelper::getInstance();
            $vm_mnf_aliases = $manufacturerHelper->get('alias', $vm_manufacturers);

            if ($vm_mnf_aliases) {
                $manuf_string = implode('__or__', $vm_mnf_aliases);
            }
            unset($query['virtuemart_manufacturer_id']);
	        $segments[] = $manuf_string;
        }

		// Custom filters
	    $componentConfig = CustomfiltersConfig::getInstance();

		// If SEF urls enabled go on
	    if ($componentConfig->get('sef_urls_for_cf', 1)) {
		    $customFilters = \cftools::getCustomFilters();

			foreach ($customFilters as $customFilter) {
				$filterVar = 'custom_f_' . $customFilter->custom_id;
				if (!empty($query[$filterVar])) {
					$customFieldHelper = CustomFieldsHelper::getInstance()->getCustomField($customFilter->custom_id);
					$filterValues = $query[$filterVar];
                    if (strpos($customFilter->disp_type, CfFilter::DISPLAY_INPUT_TEXT) === false
                        && strpos($customFilter->disp_type, CfFilter::DISPLAY_RANGE_SLIDER) === false
                        && strpos($customFilter->disp_type, CfFilter::DISPLAY_RANGE_DATES) === false) {
                        $filterValues = \cftools::hex2binArray($filterValues);
                    }

					$filterValueAliases = $customFieldHelper->get('alias', $filterValues);
					if ($filterValueAliases) {
						$filterValueAliases = array_map('urlencode', $filterValueAliases);
						$filterValueAliasesString = implode('__or__', $filterValueAliases);
						$segments[] = $customFilter->alias;
						$segments[] = $filterValueAliasesString;
						unset($query[$filterVar]);
					}
				}
			}
	    }
		// Add the 'no-category' if there is at least 1 segment and is not a category
	    if (count($segments) > 0 && $segments[0] != $categ_string) {
			array_unshift($segments, $no_category);
	    }
    }
}