<?php
/***
 * @package customfilters
 * @author Sakis Terz
 * @copyright Copyright (C) 2012-2023 breakdesigns.net . All rights reserved.
 * @license GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Joomla\Utilities\ArrayHelper;

defined('_JEXEC') or die();

class ManufacturerHelper extends CfItemsHelper
{
    /**
     * Get the items from the database
     *
     * @param   array  $ids
     *
     * @return array|void
     * @throws Exception
     * @since 2.15.0
     */
    protected function getItemsFromStorage(array $ids)
    {
        $ids = ArrayHelper::toInteger($ids);

        if (empty($ids)) {
            return [];
        }

        $langTagPrefix = cftools::getCurrentLanguagePrefix();
        $defaultLangPrefix = cftools::getDefaultLanguagePrefix();
        $db = Factory::getDbo();
        $query = $db->getQuery(true);
        $query->select($db->quoteName('main.virtuemart_manufacturer_id', 'id'))
              ->from($db->quoteName('#__virtuemart_manufacturers', 'main'))
              ->where($db->quoteName('main.virtuemart_manufacturer_id') . ' IN (' . implode(',', $ids) . ')')
              ->leftJoin($db->quoteName('#__virtuemart_manufacturers_' . $langTagPrefix) . ' AS lang ON main.virtuemart_manufacturer_id=lang.virtuemart_manufacturer_id');

        // Is multi-lingual
        // Is multi-lingual
        if (cftools::getCurrentLanguagePrefix() != cftools::getDefaultLanguagePrefix() && (VmConfig::$langCount > 1 || vmLanguage::$langCount > 1)) {
            $query->leftJoin("#__virtuemart_manufacturers_" . $defaultLangPrefix . " AS langt_def ON main.virtuemart_manufacturer_id=langt_def.virtuemart_manufacturer_id");
            $query->select("IFNULL(lang.mf_name, langt_def.mf_name) AS name");
            $query->select("IFNULL(lang.slug, langt_def.slug) AS alias");
        } else {
            $query->select($db->quoteName('lang.mf_name', 'name'));
            $query->select($db->quoteName('lang.slug', 'alias'));
        }

        $db->setQuery($query);
        return $db->loadObjectList('id');
    }
}
