<?php
/**
 * @package     customfilters
 * @copyright   Copyright (C) 2012-2022 breakdesigns.net . All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @subpackage  mod_cf_filtering
 */

/**
 * This layout is used for showing dummy/filter placeholders, while the module is loading.
 */
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;

$document = Factory::getDocument();
$input = Factory::getApplication()->input;
$selected_flt = \CfOutput::getOutput(\CfInput::getInputs(), true);
$displayManager = new \DisplayManager($params, $selected_flt);

// We try to roughly calculate the number of filters. Do note that this is a bit arbitrate in calculating the number of custom filters.
$dummyFilters = [];
$dummyFilters ['keyword'] = $displayManager->getDisplayControl('keyword_flt');
$dummyFilters ['category'] = $displayManager->getDisplayControl('category_flt');
$dummyFilters ['price'] = $displayManager->getDisplayControl('price_flt');
$dummyFilters ['stock'] = $displayManager->getDisplayControl('stock_flt');
$dummyFilters ['manufacturer'] = $displayManager->getDisplayControl('manuf_flt');

if ($displayManager->getDisplayControl('custom_flt')) {
    // We set 2 dummy custom filters
    $dummyFilters [] = $params->get('custom_flt_published', 0);
    $dummyFilters [] = $params->get('custom_flt_published', 0);
}

// Clear zeros. i.e. unpublished filters
$dummyFilters = array_filter($dummyFilters);

// We have to load all the possible scripts beforehand
require_once JPATH_BASE . '/modules/mod_cf_filtering/scriptHelper.php';
$document->addScript(Uri::root().'modules/mod_cf_filtering/assets/general.js' , ['mime' => 'text/javascript'], ['defer' => true]);
$document->addScript(Uri::root().'components/com_virtuemart/assets/js/cvfind.js', ['mime' => 'text/javascript']);
$document->addScript(Uri::root() . 'modules/mod_cf_filtering/assets/slider.js');
$document->addStyleSheet(Uri::root().'modules/mod_cf_filtering/assets/style.css');

?>

<div id="cf_wrapp_all_<?= $module->id ?>" class="cf_wrapp_all cf_wrapp_all<?= $moduleclass_sfx ?>">
    <div id="cf_ajax_loader_<?= $module->id ?>"></div>
    <?php
    if ($params->get('filter_placeholders', 1)) { ?>
        <div class="filter-placeholder-wrapper">
            <?php
            foreach ($dummyFilters as $key => $dummyFilter) {
                $display = $params->get($key.'_flt_disp_type');
                $classModifier = '';

                // Drop downs have 1 option length
                if($display == 1) {
                    $optionsLength = 1;
                    $classModifier = 'input';
                } else {
                    // Numer of labels (arbitrary number) for each type of filter
                    $optionsLength = 3;
                    if (in_array($key, ['keyword', 'price', 'stock'])) {
                        $optionsLength = 1;
                        $classModifier = 'input';
                    } elseif ($key == 'category') {
                        $optionsLength = 7;
                    } elseif ($key == 'manufacturer') {
                        $optionsLength = 5;
                    }
                }
                ?>
                <div class="filter-placeholder">
                    <?php
                    if ($key != 'keyword') { ?>
                        <div class="filter-placeholder__title cf-placeholder-loading"></div>
                        <?php
                    } ?>
                    <?php

                    for ($i = 0; $i < $optionsLength; $i++) { ?>
                        <div class="filter-placeholder__option <?= !empty($classModifier) ? 'filter-placeholder__option--' . $classModifier : '' ?> cf-placeholder-loading"></div>
                        <?php
                    } ?>
                </div>
                <?php
            } ?>
        </div>
        <?php
    } ?>
</div>

<?php
\cftools::loadScriptsNstyles();
$styles = $modObj->getStyles();
if (!empty($styles)) {
    $document->addStyleDeclaration($styles);
}

$scriptVars = $modObj->getScriptVars();
$urlHandler = new UrlHandler($module, $selected_filters);
$scriptVars['component_current_url'] = $urlHandler->getCurrentModuleUrl();

// Set the real page's vars to control the filters display (in the ajax response)
$scriptVars['xhroption'] = $input->get('option', '', 'cmd');
$scriptVars['xhrview'] = $input->get('view', 'products', 'cmd');
$scriptVars['xhrvirtuemart_category_id'] = $input->get('virtuemart_category_id', 0, 'int');
$scriptVars['xhrvirtuemart_manufacturer_id'] = $input->get('virtuemart_manufacturer_id', 0, 'int');
$scriptVars['xhrvirtuemart_product_id'] = $input->get('virtuemart_product_id', 0, 'int');

if (!empty($scriptVars)) {
    $script_var_counter = count($scriptVars);
    $j = 1;
    $script = '
		if(typeof customFiltersProp=="undefined")customFiltersProp=[];
		customFiltersProp[' . $module->id . ']={';
    foreach ($scriptVars as $varName => $value) {
        if (is_array($value)) {
            $value = reset($value);
        }
        $script .= "$varName:'$value'";
        if ($j < $script_var_counter) {
            $script .= ',';
        } //add a comma
        $j++;
    }
    $script .= '};';
    $document->addScriptDeclaration($script);

    $script = "window.addEventListener('DOMContentLoaded',() => {
        customFilters.init(" . $module->id . ");";
    $script .= "});";
    $document->addScriptDeclaration($script);
}