<?php
/**
 * --------------------------------------------------------------------------------------------
 * VP Manufacturer Carousel - Joomla! 3 Module for VirtueMart 3.0
 * --------------------------------------------------------------------------------------------
 * @package    VP Manufacturer Carousel
 * @author     Abhishek Das
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2. http://www.gnu.org/licenses/gpl-2.0.html
 * @link       http://www.virtueplanet.com
 * --------------------------------------------------------------------------------------------
*/
defined('JPATH_BASE') or die;

jimport('joomla.form.formfield');
JFormHelper::loadFieldClass('list');

if(!class_exists( 'VmConfig' ))
{
	require(JPATH_ROOT . '/administrator/components/com_virtuemart/helpers/config.php');
}

VmConfig::loadConfig();
VmConfig::loadJLang('com_virtuemart', true);

if (!class_exists('ShopFunctions'))
{
	require(VMPATH_ADMIN . '/helpers/shopfunctions.php');
}
if (!class_exists('VmModel'))
{
	require(VMPATH_ADMIN . '/helpers/vmmodel.php');
}

class JFormFieldVMManufacturers extends JFormFieldList
{
	
	public $type = 'VMManufacturers';
	
	protected static $manufacturers = null;
	
	protected function getOptions()
	{
		if(self::$manufacturers === null)
		{			
			$db = JFactory::getDBO();
			$query = $db->getQuery(true)
									->select('a.virtuemart_manufacturer_id AS value, b.mf_name AS text')
									->from('#__virtuemart_manufacturers AS a')
									->join('INNER', '#__virtuemart_manufacturers_' . VmConfig::$vmlang . ' AS b ON b.virtuemart_manufacturer_id = a.virtuemart_manufacturer_id')
									->where('a.published = 1')
									->order('b.mf_name ASC')
									->group('a.virtuemart_manufacturer_id');
			try
			{
				$db->setQuery($query);
				$manufacturers = $db->loadObjectList();
			} 
			catch (Exception $e) 
			{
				JFactory::getApplication()->enqueueMessage($e->getMessage(), 'error');
				return false;
			}

			self::$manufacturers = $manufacturers;
		}

		$options = array();
		
		if(!empty(self::$manufacturers))
		{
			foreach (self::$manufacturers as $manufacturer)
			{
				$options[] = JHTML::_('select.option', (int) $manufacturer->value, htmlspecialchars($manufacturer->text, ENT_COMPAT, 'UTF-8', false));
			}
		}
		
		$options = array_merge(parent::getOptions(), $options);
		return $options;
	}

}