<?php
/**
 * --------------------------------------------------------------------------------------------
 * VP Manufacturer Carousel - Joomla! Module for VirtueMart Store
 * --------------------------------------------------------------------------------------------
 * @package    VP Manufacturer Carousel
 * @author     Abhishek Das
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2. http://www.gnu.org/licenses/gpl-2.0.html
 * @link       http://www.virtueplanet.com
 * --------------------------------------------------------------------------------------------
*/
defined('JPATH_BASE') or die;

if(class_exists('JFormFieldVPFAdminHelper'))
{
	return;
}

jimport('joomla.form.formfield');

class JFormFieldVPFAdminHelper extends JFormField
{
	public $type = 'VPFAdminHelper';
	
	protected function getInput()
	{
		$doc         = JFactory::getDocument();
		$root        = JUri::root(true);
		$scripts     = !empty($this->element['scripts']) ? $this->element['scripts'] : null;
		$styleSheets = !empty($this->element['styleSheets']) ? $this->element['styleSheets'] : null;

		if(!class_exists('ModVPManufacturerCorouselHelper'))
		{
			require (JPATH_SITE . '/modules/mod_vp_manufacturer_carousel/helper.php');
		}
		
		ModVPManufacturerCorouselHelper::loadjQuery();

		if(version_compare(JVERSION, '3.0', '<'))
		{
			$assetPath = '/modules/mod_vp_manufacturer_carousel/assets/';
			
			if(file_exists(JPATH_ROOT . $assetPath . 'css/admin.j2.5.css'))
			{
				$doc->addStyleSheet($root . $assetPath . 'css/admin.j2.5.css');
			}
			
			$chosenCSS = '/components/com_virtuemart/assets/css/chosen.css';
			$chosenJS  = '/components/com_virtuemart/assets/js/chosen.jquery.min.js';
			
			if(file_exists(JPATH_SITE . $chosenCSS) && file_exists(JPATH_SITE . $chosenJS))
			{
				$doc->addStyleSheet($root . $chosenCSS);
				$doc->addScript($root . $chosenJS);
				$doc->addScriptDeclaration("
				jQuery(function($) {
					var vm2string ={select_all_text: 'Select all', select_some_options_text: 'Select some items'};
					setTimeout(function() {
						$('#element-box .pane-sliders').find('select').chosen();
					}, 400);
					
				});
				");
			}
		}
		else
		{
			$doc->addScriptDeclaration("jQuery(function(){jQuery('.hide-j3').closest('.control-group').hide();});");
		}

		if(!empty($scripts))
		{
			if(strpos($scripts, ',') !== false)
			{
				$scripts = explode(',', $scripts);
			}
			else
			{
				$scripts = (array) $scripts;
			}
			
			foreach($scripts as $script)
			{
				$path = JPath::clean(JPATH_ROOT . '/' . $script);
				
				if(file_exists($path))
				{
					$doc->addScript($root . '/' . trim($script));
				}
			}
		}
		
		if(!empty($styleSheets))
		{
			if(strpos($styleSheets, ',') !== false)
			{
				$styleSheets = explode(',', $styleSheets);
			}
			else
			{
				$styleSheets = (array) $styleSheets;
			}
			
			foreach($styleSheets as $styleSheet)
			{
				$path = JPath::clean(JPATH_ROOT . '/' . $styleSheet);
				
				if(file_exists($path))
				{
					$doc->addStyleSheet($root . '/' . trim($styleSheet));
				}
			}
		}
		
		return null;
	}
	
	public function getLabel() 
	{
		return null;
	}
}