<?php
/**
 * --------------------------------------------------------------------------------------------
 * VP Manufacturer Carousel - Joomla! Module for VirtueMart Store
 * --------------------------------------------------------------------------------------------
 * @package    VP Manufacturer Carousel
 * @author     Abhishek Das
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2. http://www.gnu.org/licenses/gpl-2.0.html
 * @link       https://www.virtueplanet.com
 * --------------------------------------------------------------------------------------------
*/
defined('_JEXEC') or die('Restricted access');

JLoader::register('VmConfig', JPATH_ADMINISTRATOR . '/components/com_virtuemart/helpers/config.php');

VmConfig::loadConfig();
VmConfig::loadJLang('com_virtuemart', true);

JLoader::register('VmImage', JPATH_ADMINISTRATOR . '/components/com_virtuemart/helpers/image.php');
JLoader::register('TableMedias', JPATH_ADMINISTRATOR . '/components/com_virtuemart/tables/medias.php');
JLoader::register('TableManufacturer_medias', JPATH_ADMINISTRATOR . '/components/com_virtuemart/tables/manufacturer_medias.php');
JLoader::register('TableManufacturers', JPATH_ADMINISTRATOR . '/components/com_virtuemart/tables/manufacturers.php');
JLoader::register('VirtueMartModelManufacturer_extended', __DIR__ . '/manufacturer_extended.php');

abstract class ModVPManufacturerCorouselHelper
{
	public static $offset = 0;
	
	public static function getList(&$params)
	{
		$model         = new VirtueMartModelManufacturer_extended();
		$type          = $params->get('type', 'all');
		$categories_id = (int) $params->get('categories_id', 0);
		
		if($type == 'selected')
		{
			$selected_manufacturers = (array) $params->get('manufacturers', array());
			if(empty($selected_manufacturers))
			{
				return false;
			}
			$model->selected_manufacturers = $selected_manufacturers;
		}
		elseif(!empty($categories_id))
		{
			$model->categories_id = $categories_id;
		}
		
		$manufacturers = $model->getManufacturers(true, true, true);
		$model->addImages($manufacturers, 1);

		return $manufacturers;
	}
	
	public static function loadjQuery($params = null)
	{
		if(version_compare(JVERSION, '3.0', '<'))
		{
			if(!$params || $params->get('load_jquery', 1))
			{
				$template = JFactory::getApplication()->getTemplate(true)->template;

				if(strpos($template, 'vp_') === 0)
				{
					return;
				}

				self::addScript('jquery.min.js');
				self::addScript('jquery-noconflict.js');
				self::addScript('jquery-migrate.min.js');
			}
		}
		else
		{
			JHtml::_('jquery.framework');
		}
	}
	
	public static function getOWLVersion($params)
	{
		$version = $params->get('owlcarousel_version', 0);
		
		if(JPluginHelper::isEnabled('system', 'vpframework'))
		{
			$template = plgSystemVPFrameworkHelper::getTemplate();
		}
		else
		{
			$template = JFactory::getApplication()->getTemplate();
		}
		
		$version = !empty($template->params) ? $template->params->get('owlcarousel_version', $version) : $version;

		if(empty($version))
		{
			$version = 1;
		}

		return $version;
	}
	
	public static function addScript($name)
	{
		$doc                  = JFactory::getDocument();
		$template             = JFactory::getApplication()->getTemplate(true)->template;
		$root                 = JUri::root(true);

		$paths                = array();
		$paths['media']       = '/media/jui/js/';
		$paths['virtuemart']  = '/components/com_virtuemart/assets/js/';
		$paths['template1']   = '/templates/' . $template . '/assets/js/';
		$paths['template2']   = '/templates/' . $template . '/js/';
		$paths['module']      = '/modules/mod_vp_manufacturer_carousel/assets/js/';
		
		foreach($paths as $source => $path)
		{
			if(file_exists(JPATH_SITE . $path . $name))
			{
				$doc->addScript($root . $path . $name);
				break;
			}
		}
	}
}