<?php
/**
 * --------------------------------------------------------------------------------------------
 * VP Mini Cart Module - Joomla! 3 Module for VirtueMart 3.0
 * --------------------------------------------------------------------------------------------
 * @package    VP Mini Cart Module
 * @author     Abhishek Das
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2. http://www.gnu.org/licenses/gpl-2.0.html
 * @link       http://www.virtueplanet.com
 * --------------------------------------------------------------------------------------------
*/
defined('_JEXEC') or die;

JLoader::register('ModVPMiniCartHelper', __DIR__ . '/helper.php');

$app                        = JFactory::getApplication();
$document                   = JFactory::getDocument();
$cart                       = ModVPMiniCartHelper::getCart($params);
$product_count              = ModVPMiniCartHelper::getProductCount($params);
$unique_product_count       = ModVPMiniCartHelper::getUniqueProductCount($params);
list($cartText, $cart_url)  = ModVPMiniCartHelper::getCartLink($params);
$currencyDisplay            = CurrencyDisplay::getInstance();
$customfieldsModel          = VmModel::getModel('Customfields');
$menuid                     = $app->input->getInt('Itemid', 0);
$moduleclass_sfx            = htmlspecialchars($params->get('moduleclass_sfx', ''));

if ($params->get('delay_loading', 1))
{
	$document->addScriptDeclaration("
	jQuery(document).ready(function($) {
		$(window).on('load', function() {
			$(document).trigger('updateVirtueMartCartModule');
		});
	});
	");
}

if (!empty($cart))
{
	require JModuleHelper::getLayoutPath('mod_vp_mini_cart', $params->get('layout', 'default'));
}