<?php 
/**
 * --------------------------------------------------------------------------------------------
 * VP Product Carousel - Joomla! 3 Module for VirtueMart 3.0
 * --------------------------------------------------------------------------------------------
 * @package    VP Product Carousel
 * @author     Abhishek Das
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2. http://www.gnu.org/licenses/gpl-2.0.html
 * @link       https://www.virtueplanet.com
 * --------------------------------------------------------------------------------------------
*/
defined ('_JEXEC') or die('Restricted access');
?>
<div class="vp-product-carousel<?php echo $params->get('moduleclass_sfx') ?>">
	<div id="<?php echo $module_id ?>" class="vp-product-carousel-inner owl-carousel">
		<?php foreach ($products as $product) : ?>
				<div class="product-inner">
					<div class="product-image-cont">
						<a href="<?php echo $product->link; ?>" title="<?php echo $product->product_name ?>">
							<?php if ($lazyLoad == 'true')
							{
								echo $product->images[0]->displayMediaThumb('class="responsive-image lazy-load-enabled"', false);
							}
							else
							{
								echo $product->images[0]->displayMediaThumb('class="responsive-image"', false);
							} ?>
						</a>
					</div>
					<div class="product-name-cont">
						<h2 class="product-name">
							<a href="<?php echo $product->link; ?>" title="<?php echo $product->product_name ?>" class="hover-invert"><?php echo $product->product_name ?></a>
						</h2>
					</div>
					<div class="product-price-rating-cont">
						<div class="product-price-cont">
							<?php require JModuleHelper::getLayoutPath('mod_vp_product_carousel', $params->get('layout', 'default') . '_price'); ?>
						</div>
						<?php if ($showRating) : ?>
						<div class="product-rating-cont abs-top-right display-on-mouseover">
							<?php require JModuleHelper::getLayoutPath('mod_vp_product_carousel', $params->get('layout', 'default') . '_rating'); ?>
						</div>
						<?php endif; ?>
					</div>
					<div class="product-addtocart-cont<?php echo $params->get('vm_list_show_addtocart_on_hover' , 1) ? ' display-on-mouseover' : ''; ?>">
						<?php require JModuleHelper::getLayoutPath('mod_vp_product_carousel', $params->get('layout', 'default') . '_addtocart'); ?>
					</div>
				</div>
		<?php endforeach; ?>
	</div>
</div>