<?php
/**
 * --------------------------------------------------------------------------------------------
 * VP Product Carousel - Joomla! 3 Module for VirtueMart 3.0
 * --------------------------------------------------------------------------------------------
 * @package    VP Product Carousel
 * @author     Abhishek Das
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2. http://www.gnu.org/licenses/gpl-2.0.html
 * @link       https://www.virtueplanet.com
 * --------------------------------------------------------------------------------------------
*/

defined ('_JEXEC') or die('Restricted access');

$priceType			= $params->get('displayed_price_type', 'salesPrice');
$showAdminPrice = $params->get('show_baseprice_admin', 0);
if ($priceType == 'unitPrice')
{
	$unitPriceDescription = vmText::sprintf ('COM_VIRTUEMART_PRODUCT_UNITPRICE', vmText::_('COM_VIRTUEMART_UNIT_SYMBOL_'.$product->product_unit));
}
?>
<div class="product-price" id="productPrice<?php echo $product->virtuemart_product_id ?>">
	<?php if ($product->prices['salesPrice'] <= 0 && VmConfig::get ('askprice', 1) && isset($product->images[0]) && !$product->images[0]->file_is_downloadable) : ?>
		<?php $url = JRoute::_('index.php?option=com_virtuemart&view=productdetails&task=askquestion&virtuemart_product_id=' . $product->virtuemart_product_id . '&virtuemart_category_id=' . $product->virtuemart_category_id . '&tmpl=component', false); ?>
		<a class="ask-a-question btn btn-primary btn-md" href="<?php echo $url ?>" rel="nofollow"><?php echo vmText::_ ('COM_VIRTUEMART_PRODUCT_ASKPRICE') ?></a>
	<?php else : ?>
		<?php if ($showAdminPrice) : ?>
			<?php echo $currency->createPriceDiv ('basePrice', 'COM_VIRTUEMART_PRODUCT_BASEPRICE', $product->prices); ?>
			<?php echo $currency->createPriceDiv ('basePriceVariant', 'COM_VIRTUEMART_PRODUCT_BASEPRICE_VARIANT', $product->prices); ?>
		<?php endif; ?>
		<div class="product-sales-price">
			<?php if ($priceType == 'unitPrice') : ?>
				<?php echo $currency->createPriceDiv ('unitPrice', $unitPriceDescription, $product->prices); ?>
			<?php else : ?>
				<?php echo $currency->createPriceDiv ($priceType, '', $product->prices); ?>
			<?php endif; ?>
		</div>
	<?php endif; ?>
</div>
