<?php
/**
 * --------------------------------------------------------------------------------------------
 * VP Product Carousel - Joomla! 3 Module for VirtueMart 3.0
 * --------------------------------------------------------------------------------------------
 * @package    VP Product Carousel
 * @author     Abhishek Das
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2. http://www.gnu.org/licenses/gpl-2.0.html
 * @link       https://www.virtueplanet.com
 * --------------------------------------------------------------------------------------------
*/
defined('JPATH_BASE') or die;

jimport('joomla.form.formfield');

class JFormFieldVPFAdminHelper extends JFormField
{
	public $type = 'VPFAdminHelper';
	
	protected function getInput()
	{
		$doc = JFactory::getDocument();
		$root = JUri::root(true);
		
		$scripts = !empty($this->element['scripts']) ? $this->element['scripts'] : null;
		$styleSheets = !empty($this->element['styleSheets']) ? $this->element['styleSheets'] : null;
		
		if (!empty($scripts))
		{
			if (strpos($scripts, ',') !== false)
			{
				$scripts = explode(',', $scripts);
			}
			else
			{
				$scripts = (array) $scripts;
			}
			
			foreach ($scripts as $script)
			{
				$path = JPath::clean(JPATH_ROOT . '/' . $script);
				
				if (file_exists($path))
				{
					$doc->addScript($root . '/' . trim($script));
				}
			}
		}
		
		if (!empty($styleSheets))
		{
			if (strpos($styleSheets, ',') !== false)
			{
				$styleSheets = explode(',', $styleSheets);
			}
			else
			{
				$styleSheets = (array) $styleSheets;
			}
			
			foreach ($styleSheets as $styleSheet)
			{
				$path = JPath::clean(JPATH_ROOT . '/' . $styleSheet);
				
				if (file_exists($path))
				{
					$doc->addStyleSheet($root . '/' . trim($styleSheet));
				}
			}
		}
		
		return null;
	}
	
	public function getLabel() 
	{
		return null;
	}
}