<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Framework for Joomla!
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

JLoader::register('ModVPWishlistHelper', __DIR__ . '/helper.php');

if (JPluginHelper::isEnabled('system', 'vpframework'))
{
	$_template = plgSystemVPFrameworkHelper::getTemplate();
	
	if ($_template->params->get('vpframework', 0))
	{
		$app          = JFactory::getApplication();
		$document     = JFactory::getDocument();
		$user         = JFactory::getUser();
		$products     = VPFrameworkVM::getWishlist();
		$url          = '';
		$article_id   = (int) $_template->params->get('wishlist_article_id', 0);
		$Itemid       = !empty($article_id) ? $_template->getArticleItemid($article_id) : 0;
		$Itemid       = !empty($Itemid) ? '&Itemid=' . $Itemid : '';
		
		if (!empty($article_id))
		{
			$url = JRoute::_('index.php?option=com_content&view=article&id=' . $article_id . $Itemid, false);
			$url = str_replace('&amp;', '&', $url);
		}

		$product_count    = count($products);
		$currencyDisplay  = CurrencyDisplay::getInstance();
		$menuid           = $app->input->getInt('Itemid', 0);
		$moduleclass_sfx  = htmlspecialchars($params->get('moduleclass_sfx', ''));
		
		require JModuleHelper::getLayoutPath('mod_vp_wishlist', $params->get('layout', 'default'));
	}
}