<?php
/**
 *
 * Breakdesigns Ajax system plugin
 *
 * @package     customfilters
 * @link        https://breakdesigns.net
 * @copyright   Copyright (c) 2012-2021 breakdesigns.net. All rights reserved.
 * @license        http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 *                customfilters is free software. This version may have been modified
 *                pursuant to the GNU General Public License, and as distributed
 *                it includes or is derivative of works licensed under the GNU
 *                General Public License or other free or open source software
 *                licenses.
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\CMSPlugin;

class PlgSystemBreakdesignsajax extends CMSPlugin
{

    public function onAfterDispatch()
    {
        $app = Factory::getApplication();
        $doc = Factory::getApplication()->getDocument();
        $format = $doc->getType();
        $buffer = trim($doc->getBuffer('component'));
        if (empty($buffer)) {
            return;
        }
        $is_json = !empty($buffer[0]) && $buffer[0] == '{';
        $xml_pos = strpos($buffer, '<?xml');
        $is_xml = $xml_pos == 0 && $xml_pos !== false;

        if ($format == 'html' && !$is_json && !$is_xml && $app->isClient('site')) {
            $newBuffer = <<<HTML
			<div id="bd_results" role="region" aria-live="polite">
                <div id="cf_res_ajax_loader"></div>
                    {$buffer}
                </div>
HTML;
            $doc->setBuffer($newBuffer, 'component');
        }
    }
}
