<?php
/**
 * @package CustomfieldsforallBasebase
 * @copyright   Copyright (C)2014-2023 breakdesigns.net . All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die('Restricted access');

require_once __DIR__ . '/../bootstrap.php';

use Joomla\CMS\Form\FormField;
use Breakdesigns\Plugin\System\Customfieldsforallbase\Model\Customfield;
use Breakdesigns\Plugin\System\Customfieldsforallbase\RenderFields;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;

class JFormFieldCustomvalues extends FormField
{
    /**
     * @var string
     * @since 1.1.0
     */
    protected $type = 'customvalues';


    protected function getInput()
    {
        $fieldname = 'cf_val';
        $jinput = Factory::getApplication()->input;
        $virtuemart_custom_id = $jinput->get('virtuemart_custom_id', array(), 'ARRAY');
        $custom_params = [];

        if (is_array($virtuemart_custom_id)) {
            $virtuemart_custom_id = end($virtuemart_custom_id);
        }
        if($virtuemart_custom_id) {
            $parentPlugin = (string)$this->element['parentPlugin'];
            $customfield = Customfield::getInstance($virtuemart_custom_id, $parentPlugin);
            $custom_params = $customfield->getCustomfieldParams($virtuemart_custom_id);
            $custom_params['single_entry'] = !empty($custom_params['is_price_variant']) ? true : false;
        }
        $renderFields = new RenderFields();
        $html = $renderFields->fetchCustomvalues($fieldname, $virtuemart_custom_id, $this->value, 0, $custom_params);
        return $html;
    }

    protected function getLabel()
    {
        $title = '';
        if (empty($this->value)) {
            $title = '<strong>' . Text::_($this->element['label']) . '</strong><br />' . Text::_($this->element['description']);
        }
        $html = '<label data-original-title="<strong>' . Text::_($this->element['label']) . '</strong><br />' . Text::_($this->element['description']) . '" id="params_display_type-lbl" for="params_' . $this->element['name'] . '" class="hasTooltip" title="' . $title . '">' . Text::_($this->element['label']) . '</label>';
        return $html;
    }
}
