<?php
/**
 * @package     CustomfieldsforallBasebase
 * @copyright   Copyright (C)2014-2023 breakdesigns.net . All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die('Restricted access');

require_once __DIR__ . '/../bootstrap.php';

use Joomla\CMS\Form\FormField;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Breakdesigns\Plugin\System\Customfieldsforallbase\RenderFields;

class JFormFieldDatatype extends FormField
{

    protected $type = 'datatype';


    protected function getInput()
    {
        $jinput = Factory::getApplication()->input;
        $virtuemart_custom_id = $jinput->get('virtuemart_custom_id', array(), 'ARRAY');
        if (is_array($virtuemart_custom_id)) {
            $virtuemart_custom_id = end($virtuemart_custom_id);
        }
        $value = !empty($this->value) ? $this->value : 'string';
        $renderFields = new RenderFields;
        $html = $renderFields->fetchDatatype($virtuemart_custom_id, $this->name, $value);

        return $html;
    }

    protected function getLabel()
    {
        $title = '';
        if (empty($this->value)) {
            $title = '<strong>' . Text::_($this->element['label']) . '</strong><br />' . Text::_($this->element['description']);
        }
        $html = '<label data-original-title="<strong>' . Text::_($this->element['label']) . '</strong><br />' . Text::_($this->element['description']) . '" id="params_display_type-lbl" for="params_' . $this->element['name'] . '" class="hasTooltip" title="' . $title . '">' . Text::_($this->element['label']) . '</label>';

        return $html;
    }
}
