<?php
/**
 * @package     CustomfieldsforallBasebase
 * @copyright   Copyright (C)2014-2023 breakdesigns.net . All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('JPATH_BASE') or die;

require_once __DIR__ . '/../bootstrap.php';

use Joomla\CMS\Form\FormField;
use Joomla\CMS\Factory;
use Breakdesigns\Plugin\System\Customfieldsforallbase\Model\Customfield;
use Breakdesigns\Plugin\System\Customfieldsforallbase\RenderFields;

/**
 *
 * Class that generates a filter list
 * @author Sakis Terzis
 */
class JFormFieldDisplaytypes extends FormField
{
    /**
     *
     * @var string
     */
    protected $type = 'datatype';

    /**
     * (non-PHPdoc)
     * @see FormField::getInput()
     */
    protected function getInput()
    {
        $jinput = Factory::getApplication()->input;
        $virtuemart_custom_id = $jinput->get('virtuemart_custom_id', array(), 'ARRAY');
        if (is_array($virtuemart_custom_id)) {
            $virtuemart_custom_id = end($virtuemart_custom_id);
        }

        /*
         * The only reason for these 2 lines is that, here is the place where the Customfield is instantiated.
         * Hence we want it to get instantiated with the proper pluginName attribute
         */
        $parentPlugin = (string)$this->element['parentPlugin'];
        $customfield = Customfield::getInstance($virtuemart_custom_id, $parentPlugin);

        $value = !empty($this->value) ? $this->value : 'string';
        $renderFields = new RenderFields;
        $singleSelect = isset($this->element['single-select']) && $this->element['single-select'] == 'true' ? true : false;
        $html = $renderFields->fetchDisplaytypes($this->name, $virtuemart_custom_id, $value, $singleSelect);

        return $html;
    }
}
