<?php
/**
 * @package DependentCustomfieldsforall
 * @copyright   Copyright (C)2014-2023 breakdesigns.net . All rights reserved.
 * @license GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Language\Text;

if(!empty($multiple)) {
    $type='checkbox';
}
else {
    $type='radio';
}
/** @var array $values_obj_list*/
$values_obj_list;

/** @var array $custom_params*/
$custom_params;

/** @var  array $product_value_ids*/
$product_value_ids;

/** @var string $wrapper_id */
$wrapper_id='cffall_color_btn_set'.$row;

/** @var string $field_prefix*/
$field_prefix;

/** @var  Breakdesigns\Plugin\System\Customfieldsforallbase\Model\CustomFieldsForAllLanguageHandler $this->languageHandler*/
$this->languageHandler;

//add buttons toolbar
if(count($values_obj_list)>1 && !empty($multiple)){?>

<div class="cf4all_values_toolbar" style="min-height:3em; margin-top: 1em;">
	<button class="btn btn-sm btn-outline-secondary" type="button" onclick="jQuery('#<?php echo $wrapper_id?> input').attr('checked','checked');">
	  <?php echo Text::_('JGLOBAL_SELECTION_ALL')?>
	 </button>
	<button class="btn btn-sm btn-outline-secondary" type="button" onclick="jQuery('#<?php echo $wrapper_id?> input').removeAttr('checked');">
	  <?php echo Text::_('JGLOBAL_SELECTION_NONE')?></button>
</div>
<div class="clr"></div>
<?php
}?>

<div class="cffall_btns_wrapper" id="<?php echo $wrapper_id ?>" style="max-height:200px; overflow-y:scroll;">
    <?php
    foreach ($values_obj_list as $v) {
        //styling
        $tooltip = '';
        $tooltip = '';
        $class = '';

        //the value displayed as label within the button
        $label_html = '';
        $custom_value_name_multi = explode('|', $v->customsforall_value_name);
        $count_multi_values = count($custom_value_name_multi);
        $width = 100 / $count_multi_values;
        $customsforall_value_label = '';
        $parent_label = '';

        if ($count_multi_values == 1) {
            $customsforall_value_label = $custom_value_name_multi[0];
        }

        //multi-colors
        foreach ($custom_value_name_multi as $key => $custom_value_name) {
            // we want the original value intact
            $custom_value = $custom_value_name;
            // If it has a parent, the custom value contains the parent values as well
            if(!empty($custom_params['parent_id'])) {
                $custom_value = $filterInput->clean($custom_value_name, $dataType = 'COLOR_HEX');

                // The inside label should only include the color
                if ($customsforall_value_label) {
                    $customsforall_value_label = $custom_value;
                }

                /*
                 * The outside label/tooltip should include the parent dependencies + label (added later)
                 * In case of multi-color values, this should run only for the 1st color.
                 */
                if($custom_value && $key == 0) {
                    $parent_label = str_replace($custom_value, '', $custom_value_name);
                }
            }
            $color = $filterInput->checkNFormatColor($custom_value);
            if ($color === false) {
                continue;
            }
            $isHex = false;
            if ((strlen($color) == 4 | strlen($color) == 7) && strpos($color, '#') !== false) {
                $isHex = true;
            }

            $label_html .= <<<INNERVALUE
            <div class="cf4all_inner_value" style="color:#ffffff; text-shadow:-1px 1px #444444; background:$color;">
                $customsforall_value_label
            </div>
INNERVALUE;

        }

        $el_id = 'cffall_color_bn' . $v->customsforall_value_id . '_' . $row;
        //check selected
        if (in_array($v->customsforall_value_id, $product_value_ids)) {
            $selected = 'checked="checked"';
        }

        if (!empty($v->customsforall_value_label)) {
            $tooltip = $this->languageHandler->__($v, $lang = '', $group = 'label') . ' ';
        } else {
            $tooltip = '';
        }

        // In case we have a parent value, the tooltip should display the parent relationship
        if(!empty($custom_params['parent_id'])) {
            if(empty($tooltip)) {
                $tooltip = $v->customsforall_value_name;
            }
            // create the tooltip appending the parent values at the start of the tooltip
            elseif($parent_label) {
                $tooltip = $parent_label . $tooltip;
            }
        }

        if (!empty($tooltip)) {
            $tooltip = ' data-tip="' . $tooltip . '"';
            $class .= ' cf4allTip';
        }

        $selectorHtmlClass = $selected ? 'cf4all_selected_indicator--selected' : '';
        ?>
        <input type="<?php echo $type ?>" id="<?php echo $el_id ?>"
               name="<?php echo $this->_product_paramName ?>[<?php echo $row ?>]<?php echo $field_prefix ?>[<?= $this->_name;?>][value][]"
               value="<?php echo $v->customsforall_value_id ?>" <?php echo $selected ?> />

        <label for="<?php echo $el_id ?>" <?php echo $tooltip ?> class="<?php echo $class ?>">
            <div class="cf4all_value_wrapper">
                <div class="cf4all_selected_indicator <?= $selectorHtmlClass?>"></div>
                <div class="cf4all_inner_values_wrapper">
                    <?= $label_html;?>
                </div>
            </div>
        </label>
        <?php
        $selected = '';
    }
    ?>
    <div style="clear:both"></div>
</div>

<script>
jQuery(function($){

  $(".cf4allTip").hover(function() {
  	var label=$(this).attr("data-tip");
		$( this ).append( $("<span style=\"display:block; position:absolute; margin-top:.3rem; margin-inline-start: 1.7rem; background:#ffffff; border:1px solid #ccc; padding:5px; color:black;\">"+label+"</span>" ) );
	},
	function() {
		$( this ).find( "span:last" ).remove();
	});

	//insert only once
	if(typeof cf_rule_inserted =="undefined"){
		var stylesheet = document.styleSheets[0];
		var selector= [];
		var rule= [];

		selector[0] = '.cffall_btns_wrapper input[type="radio"]:checked+label .cf4all_inner_values_wrapper,.cffall_btns_wrapper input[type="checkbox"]:checked+label .cf4all_inner_values_wrapper';
		rule[0] = '{border: 2px solid #555555 !important; box-shadow: 0 0 4px rgba(10, 10, 10, 0.8);}'

        selector[1] = '.cffall_btns_wrapper label';
        rule[1] = `{
        display: inline-block;
        width: 5rem;
        overflow: hidden;
        margin-inline-end: 0.7rem !important;
        margin-bottom: 0.7rem !important;
        }`;

        selector[2] = '.cffall_btns_wrapper .cf4all_inner_value';
        rule[2] = `{
        height: 1.8rem;
	    width: auto;
	    text-align: center;
	    flex: auto;
	    font-size: 1rem;
	    line-height: 1.8rem;}`;

		selector[3]='.cffall_btns_wrapper input[type=radio],.cffall_btns_wrapper input[type=checkbox]';
		rule[3]='{display: none; }';

		selector[4]='.cffall_btns_wrapper';
		rule[4]='{clear:both; padding:10px 0px;}';

        selector[5]='.cf4all_value_wrapper';
        rule[5]=`{
	    display: flex;}`;

        selector[6]='.cf4all_inner_values_wrapper';
        rule[6]=`{
        flex: 3 1 auto;
	    display:flex;
	    border: 1px solid #ccc;
	    border-radius: 2px;}`;

        selector[7]= '.cf4all_selected_indicator';
        rule[7] = `{
        width: 1.2rem;
        height: 1.2rem;
        border: 1px solid #ccc;
        margin-inline-end: .3rem;
        }`;

        selector[8]= '.cffall_btns_wrapper input[type="radio"]:checked+label .cf4all_selected_indicator:before,.cffall_btns_wrapper input[type="checkbox"]:checked+label  .cf4all_selected_indicator:before';
        rule[8] = `{
        content: "";
        display: inline-block;
        margin-top: -.15rem;
        padding: 0;
        position: absolute;
        border: solid #0b5b99;
        border-width: 0 8px 5px 0;
        transform: rotate(45deg) scaleX(.38) scaleY(.7);
        width: 1.2em;
        height: 1.2em;
        overflow: hidden;
            }`;

		if (stylesheet.insertRule) {
			for(let i=0; i<selector.length; i++){
		    	stylesheet.insertRule(selector[i] + rule[i], stylesheet.cssRules.length);
		    }
		} else if (stylesheet.addRule) {
			for(let i=0; i<selector.length; i++){
		    	stylesheet.addRule(selector[i], rule[i], -1);
		    }
		}
		cf_rule_inserted=true;
	}
});
</script>
