<?php
/**
 * @package DependentCustomfieldsforall
 * @copyright   Copyright (C)2014-2023 breakdesigns.net . All rights reserved.
 * @license GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;

$wrapper_id='customsforall_'.$row.'_'.$block->getVirtuemartCustom_id();

$is_js_loaded = Factory::getApplication()->input->get('scripts_loaded', false, 'BOOLEAN');
if (!$is_js_loaded) {
    $script_path = CF4ALLBASE_PLUGIN_PATH . DIRECTORY_SEPARATOR . 'view' . DIRECTORY_SEPARATOR . 'admin' . DIRECTORY_SEPARATOR . 'js' . DIRECTORY_SEPARATOR . 'select2.min.js';
    $css_path = CF4ALLBASE_PLUGIN_PATH . DIRECTORY_SEPARATOR . 'view' . DIRECTORY_SEPARATOR . 'admin' . DIRECTORY_SEPARATOR . 'css' . DIRECTORY_SEPARATOR . 'select2.min.css';

    $html = '';
    // Inject the script in the doc
    ob_start();
    include($script_path);
    $script = ob_get_contents();
    $script .= $scriptCommands;
    $html .= '<script type="text/javascript">' . $script . '</script>';
    ob_end_clean();
    // Inject the css in the doc
    if (isset($css_path)) {
        ob_start();
        include($css_path);
        $css = ob_get_contents();
        $html .= '<style>' . $css . '</style>';
        ob_end_clean();
    }
    echo $html;
}

//add buttons toolbar
if(count($values_obj_list)>1 && !empty($multiple)) {
?>
    <div class="cf4all_values_toolbar" style="min-height:3em; margin-top: 1em;">
		<button class="btn btn-sm btn-outline-secondary" type="button"
		onclick="jQuery('#<?php echo $wrapper_id?> option').removeAttr('selected'); jQuery('#<?php echo $wrapper_id?>').trigger('change');"><?php echo Text::_('JGLOBAL_SELECTION_NONE')?>
		</button>
	<div class="clr"></div>
	</div>
	<div class="clr"></div>
<?php
    }?>

<div class="cf4all_select_wrapper" style="margin-bottom:1em">
    <select class="cf-js-select2"
            id="<?= $wrapper_id ?>"
            name="<?= $this->_product_paramName ?>[<?= $row;?>]<?= $field_prefix ?>[<?= $this->_name;?>][value][]"
            data-custom-id="<?= $block->getVirtuemartCustom_id();?>"
            data-parent-plugin="<?= $block->getCustom()->getPluginName();?>"
            style="width: auto;"
        <?= $multiple ?>>
        <?php
        if (empty($multiple)) {
            ?>
            <option value=""><?php
                echo Text::_('PLG_CUSTOMSFORALL_SELECT_AN_OPTION') ?></option>
            <?php
        }
        foreach ($values_obj_list as $v) {
            $selected = '';
            if (in_array($v->customsforall_value_id, $product_value_ids)) {
                $selected = 'selected="selected"';
            } ?>
            <option value="<?php
            echo $v->customsforall_value_id ?>" <?php
            echo $selected ?> style="<?php
            echo $option_style ?>">
                <?php
                echo $v->customsforall_value_name; ?>
            </option>
            <?php
        } ?>
    </select>
</div>
<script>

    jQuery(function($) {

        // JS Select2
        $(".cf-js-select2:not(.select2-hidden-accessible)").select2({
                ajax: {
                    url: 'index.php?option=com_ajax&tmpl=component&view=custom&plugin=getCustomValues&format=json&',
                    data: function (params) {
                        let query = {
                            virtuemart_custom_id: $(this).attr('data-custom-id'),
                            parentPlugin: $(this).attr('data-parent-plugin'),
                            search: params.term,
                            page: params.page || 1
                        }

                        // Query parameters will be ?search=[term]&page=[page]
                        return query;
                    },
                    processResults: function (data, params) {
                        params.page = params.page || 1;
                        data = JSON.parse(data.data);
                        return data;
                    }
                }
            }
        );

        // Destroy chosen if exists (Does not work so far)
        $(".cf-js-select2").chosen("destroy");
        $(".cf-js-select2").show().removeClass('chzn-done');
    });

        if(typeof cf_css_dropdown == "undefined"){
        const style = `
         /* Hide chosen */
        .cf4all_select_wrapper .chzn-container{
            display: none;
        }
        ul.select2-selection__rendered {
            margin:0;
        }
        .cf4all_select_wrapper .select2-container--default .select2-selection--multiple li.select2-selection__choice {
            background: #3071A9;
            color: #fff;
            padding-top: .2rem;
            padding-bottom: .2rem;
            padding-right: .2rem;
            padding-left: 26px;
        }
        .cf4all_select_wrapper .select2.select2-container {
            width: auto !important;
            min-width: 150px;
        }
        .cf4all_select_wrapper .select2-container--default .select2-selection--multiple button.select2-selection__choice__remove {
            color: #fff;
            font-size: 1.2em;
            padding: .2rem 6px;
            margin: 0;
        }

        .cf4all_select_wrapper .select2-container--default .select2-selection--multiple button.select2-selection__choice__remove:hover, .cf4all_select_wrapper .select2-container--default .select2-selection--multiple button.select2-selection__choice__remove:focus {
            background-color: #87B8E1;
        }

        .cf4all_select_wrapper .select2-container--default .select2-selection--multiple li.select2-selection__choice {
            display: block;
        }

        .select2-container .select2-search--dropdown .select2-search__field {
            height: auto;
        }
        .cf4all-value-wrapper .select2-container {
            display: block;
            margin-bottom: 1rem;
        }
        /* The search term goes out of the box in the old vm admin template */
        .select2-search__field {
            float: none;
        }
        `;
        let styleEl = document.createElement('style');
        styleEl.textContent = style;
        document.querySelector('head').appendChild(styleEl);
        cf_css_dropdown = true;
    }
</script>