<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VirtuePlanet Framework for Joomla!
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

jimport('joomla.plugin.helper');

$doc     = JFactory::getDocument();
$tab     = $doc->_getTab();
$lineEnd = $doc->_getLineEnd();
$user    = JFactory::getUser();
$root    = JUri::root(true);

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');

//$doc->addStyleSheet($root . '/media/vpframework/css/pure.min.css');
$doc->addStyleSheet($root . '/media/vpframework/css/aicons.css');
$doc->addStyleSheet($root . '/media/vpframework/css/animate.css');
$doc->addStyleSheet($root . '/media/vpframework/css/vpframework.joomla4.admin.css?ver=5.4');

JHtml::_('jquery.framework');

$doc->addScript($root . '/media/vpframework/js/jquery.biscuit.min.js');
$doc->addScript($root . '/media/vpframework/js/vpframework.admin.js?ver=5.4');

JHtml::_('behavior.formvalidator');
JHtml::_('behavior.keepalive');
JHtml::_('behavior.multiselect');
JHtml::_('formbehavior.chosen', '#jform_params_fullwidth_itemid');

$doc->addScriptDeclaration($tab . $tab . "window.jtoken = '" . JSession::getFormToken() . "';" . $lineEnd);

$title = '';

if (isset(JFactory::getApplication()->JComponentTitle))
{
	$title = JFactory::getApplication()->JComponentTitle;
}

$form            = $this->getForm();
$fieldSets       = $form->getFieldsets('params');
$ignoreFieldsets = array('basic', 'description');
$count           = 0;
$addLessFields   = false;
$selectedTheme   = '';
$adminHelper     = VPFrameworkAdmin::getInstance();
$dlkHelper       = VPFrameworkDlk::getInstance();
?>
<div id="vpf-edit-container">
	<div id="vpf-layout" class="joomla-4">
		<div id="vpf-offcanvas-menu">
			<div class="inner">
				<a class="vpf-menu-toggler" href="#vpf-offcanvas-menu"><i class="aicon-arrow-right22 on-close"></i><i class="aicon-arrow-left22 on-open"></i></a>
				<div class="vpf-menu-header"><?php echo trim(strip_tags($title)) ?></div>
				<?php if (!empty($fieldSets)) : ?>
				<ul>
					<li class="active"><a href="#vpf-params-overview" data-id="#vpf-params-overview" title="Dashboard"><i class="aicon-home aicon-align-middle"></i><span class="menu-text">&nbsp; Dashboard</span></a></li>
					<?php foreach ($fieldSets as $name => $fieldSet) : ?>
						<?php
						if (in_array($name, $ignoreFieldsets) || (isset($fieldSet->repeat) && $fieldSet->repeat == true))
						{
							continue;
						} 
						if (!empty($fieldSet->label))
						{
							$flabel = JText::_($fieldSet->label, true);
						}
						else
						{
							$flabel = strtoupper('JGLOBAL_FIELDSET_' . $name);
							if (JText::_($flabel, true) == $flabel)
							{
								$flabel = strtoupper($app->input->get('option') . '_' . $name . '_FIELDSET_LABEL');
							}
							$flabel = JText::_($flabel, true);
						} 
						if (isset($fieldSet->menuicon) && !empty($fieldSet->menuicon))
						{
							$label = '<i class="aicon-' . trim($fieldSet->menuicon) . ' aicon-align-middle"></i><span class="menu-text">&nbsp; ' . $flabel . '</span>';
						}
						else
						{
							$label = $flabel;
						}
						?>
						<li><a href="#vpf-params-<?php echo $name ?>" data-id="#vpf-params-<?php echo $name ?>" title="<?php echo $flabel ?>"><?php echo $label ?></a></li>
					<?php endforeach; ?>
					<?php if ($user->authorise('core.edit', 'com_menu') && $this->item->client_id == 0 && $this->canDo->get('core.edit.state')) : ?>
						<li><a href="#vpf-params-assignment" data-id="#vpf-params-assignment" title="<?php echo JText::_('COM_TEMPLATES_MENUS_ASSIGNMENT'); ?>"><i class="aicon-cogs aicon-align-middle"></i><span class="menu-text">&nbsp; <?php echo JText::_('COM_TEMPLATES_MENUS_ASSIGNMENT', true); ?></span></a></li>
					<?php endif; ?>
				</ul>
				<?php endif; ?>
			</div>
		</div>
		<div id="vpf-content">
			<div class="vpf-main">
				<form action="<?php echo JRoute::_('index.php?option=com_templates&view=style&layout=edit&id=' . (int) $this->item->id); ?>" method="post" name="adminForm" id="style-form" class="form-validate">
					
					<div class="vpf-sidemenu-cont">
						<div id="vpf-params-overview" class="vpf-sidemenu-content selected">
							<div class="row">
								<div class="col-md-6">
									<fieldset>
										<legend>About <?php echo JText::_($this->item->template); ?></legend>
										<p><?php echo JText::_($this->item->xml->description); ?></p>
									</fieldset>
								</div>
								<div class="col-md-6">
									<fieldset class="form-horizontal">
										<legend>Overview</legend>
										<div class="control-group">
											<div class="control-label"><?php echo $form->getLabel('title'); ?></div>
											<div class="controls"><?php echo str_replace(array('input-xxlarge', 'input-large-text'), '', $form->getInput('title')); ?></div>
										</div>
										<div class="control-group">
											<div class="control-label"><?php echo $form->getLabel('home'); ?></div>
											<div class="controls"><?php echo $form->getInput('home'); ?></div>
										</div>
										<div class="control-group">
											<div class="control-label"><?php echo $form->getLabel('template'); ?></div>
											<div class="controls"><?php echo $form->getInput('template'); ?></div>
										</div>
									</fieldset>
								</div>
							</div>
							<div class="row">
								<div class="col-md-6">
									<?php if (!empty($dlkHelper->package) && is_object($dlkHelper->package)) : ?>
										<fieldset>
											<legend>Version</legend>
											<div id="vp-versions">
												<table class="table table-striped table-bordered">
													<thead>
														<tr>
															<th>Extension</th>
															<th>Version</th>
															<th>Latest Version</th>
														</tr>
													</thead>
													<tbody>
														<tr>
															<td>
																<?php echo JText::_($dlkHelper->package->name); ?>
															</td>
															<td>
																<span class="present-version label" data-extensionid="<?php echo $dlkHelper->package->extension_id; ?>"><?php echo $dlkHelper->package->version ?></span>
															</td>
															<td data-action="getversion" data-extensionid="<?php echo $dlkHelper->package->extension_id; ?>" data-currentversion="<?php echo $dlkHelper->package->version ?>">
																<i class="aicon-spin aicon-spinner"></i><span>&nbsp;&nbsp;Checking for update ...</span>
															</td>
														</tr>
														<tr class="found hide">
															<td colspan="2">
																<p>A template update is available. <a data-update="infourl" href="#" class="hide">Learn more.</a></p>
																<p data-update="nodlk" class="text-danger hide">Please update your membership information to get the update.</p>
															</td>
															<td>
																<button data-update="btn" type="button" onclick="window.open('index.php?option=com_installer&view=update');return false;" class="btn btn-primary" disabled>
																	<span class="aicon-checkmark"></span>
																	<span>&nbsp;Update</span>
																</button>
															</td>
														</tr>
													</tbody>
												</table>
											</div>
										</fieldset>
									<?php endif; ?>
									<fieldset class="form-horizontal form-horizontal-vpdlk">
										<legend>Membership Information</legend>
										<?php if (!empty($dlkHelper->package) && is_object($dlkHelper->package)) : ?>
											<?php echo $dlkHelper->getInput() ?>
										<?php else : ?>
											<div class="alert alert-danger alert-error">
												<p>Package information missing. Please re-install the full template package. If problem persists please contact VirtuePlanet Support on <a href="https://www.virtueplanet.com/forum/" target="_blank">Forum</a>.</p>
											</div>
										<?php endif; ?>
									</fieldset>
								</div>
								<div class="col-md-6">
									<fieldset>
										<legend>File Verification</legend>
										<div id="vp-file-verification">
											<div class="running"><i class="aicon-spin aicon-spinner aicon-align-vertical"></i>&nbsp; File verification running...</div>
											<div class="failed text-danger hide">File verification failed</div>
											<div class="success hide">
												<p class="foundChanges hide">File verifier found changes in the system.</p>
												<p class="foundNoChange text-success hide">File verifier did not find any changes in the system.</p>
												<div class="vp-files-info hide">
													<div class="file-list-header">Missing Files: <span class="deletedCount badge bg-secondary hasTooltip" title="File count"></span></div>
													<pre class="deletedFiles"></pre>
												</div>
												<div class="vp-files-info hide">
													<div class="file-list-header">Modified Files: <span class="changedCount badge bg-secondary hasTooltip" title="File count"></span></div>
													<pre class="changedFiles"></pre>
												</div>
												<div class="vp-files-info hide">
													<div class="file-list-header">New Files: <span class="newCount badge bg-secondary hasTooltip" title="File count"></span></div>
													<pre class="newFiles"></pre>
												</div>
											</div>
										</div>
									</fieldset>
								</div>
							</div>
						</div>
						
						<?php if (!empty($fieldSets)) : ?>
							<?php foreach ($form->getFieldsets('params') as $name => $fieldset) : ?>
								<?php
								if (in_array($name, $ignoreFieldsets) || (isset($fieldSet->repeat) && $fieldSet->repeat == true))
								{
									continue;
								} ?>
								<div id="vpf-params-<?php echo $name ?>" class="vpf-sidemenu-content">
									<?php
									$fields = $this->form->getFieldset($fieldset->name); 
									if ($total = count($fields)) { 
										$count = 0;
										$setCount = 0;
										$needClose = false;
										$needRowClose = false;
										$startRow = true;
										$per_row = 2;
										foreach ($fields as $key => $field) 
										{
											if ($field->hidden)
											{
												echo $field->input;
												echo '<div class="clearfix"></div>';
												$total--;
											}
											else
											{
												$count++;
												
												if (strtolower($field->type) == 'spacer' || $count == 1)
												{
													if ($needClose)
													{
														if ($addLessFields)
														{
															$selectedTheme = !empty($this->item->params['theme']) ? $this->item->params['theme'] : $selectedTheme;
															$lessFields = $adminHelper->getLessFields($selectedTheme);
															if (!empty($lessFields))
															{
																echo '<div id="vpLessFields">';
																echo $lessFields;
																echo '</div>';
															}
															$addLessFields = false;
														}
														echo '</fieldset>';
														echo '</div>';
														$needClose = false;
													}
													
													if (($setCount == $per_row) && $needRowClose)
													{
														echo '</div>';
														$setCount = 0;
														$startRow = true;
														$needRowClose = false;
													}	
													
													if ($startRow)
													{
														echo '<div class="row">';
														$startRow = false;
														$needRowClose = true;
													}

													if ($count < $total)
													{
														echo '<div class="col-md-6">';
														echo '<fieldset class="form-horizontal">';
														if (strtolower($field->type) == 'spacer' && ($legend = $field->getAttribute('label')))
														{
															echo '<legend>' . JText::_($legend) . '</legend>';
														}
														$setCount++;
														$needClose = true;
													}

												} 
												if (strtolower($field->type) != 'spacer') { ?>
													<?php if (strtolower($field->type) == 'groupheading') : ?>
														<div class="control-group">
															<?php echo $field->input; ?>
														</div>
													<?php else : ?>
														<div class="control-group">
															<div class="control-label">
																<?php echo $field->label; ?>
																<?php if ($field->getAttribute('labelnote')) : ?>
																	<div class="small muted label-note"><?php echo JText::_($field->getAttribute('labelnote')) ?></div>
																<?php endif; ?>
															</div>
															<div class="controls">
																<?php echo $field->input; ?>
																<?php if ($field->getAttribute('name') == 'theme')
																{
																	$addLessFields = true;
																	$selectedTheme = $field->getAttribute('default');
																} ?>
																<?php if ($field->getAttribute('note')) : ?>
																	<div class="small muted"><?php echo JText::_($field->getAttribute('note')) ?></div>
																<?php endif; ?>
															</div>
														</div>
													<?php endif; ?>
												<?php
												}
												
											}
											
											if ($total == $count)
											{
												if ($needClose)
												{
													if ($addLessFields)
													{
														$selectedTheme = !empty($this->item->params['theme']) ? $this->item->params['theme'] : $selectedTheme;
														$lessFields = $adminHelper->getLessFields($selectedTheme);
														if (!empty($lessFields))
														{
															echo '<div id="vpLessFields">';
															echo $lessFields;
															echo '</div>';
														}
														$addLessFields = false;
													}
													echo '</fieldset>';
													echo '</div>';
													$needClose = false;
													
													if ($needRowClose)
													{
														echo '</div>';
														$startRow = true;
														$needRowClose = false;
													}
												}
												if ($needRowClose)
												{
													echo '</div>';
													$startRow = true;
													$needRowClose = false;
												}
											}
										}

									} ?>
								</div>
							<?php endforeach;?>
						<?php endif; ?>
						
						<div id="vpf-params-assignment" class="vpf-sidemenu-content">
							<?php echo $this->loadTemplate('assignment'); ?>
						</div>
						
						<?php echo $form->getInput('client_id'); ?>
						<input type="hidden" name="task" value="" />
						<?php echo JHtml::_('form.token'); ?>
					</div>
				</form>
			</div>
		</div>
	</div>
</div>