<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VirtuePlanet Framework for Joomla!
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('JPATH_PLATFORM') or die;

JFormHelper::loadFieldClass('list');

class JFormFieldArticles extends JFormFieldList
{
	protected static $articles = null;

	public $type = 'Articles';
	
	public function getOptions()
	{
		if (static::$articles === null)
		{
			$db    = JFactory::getDBO();
			$query = $db->getQuery(true)
				->select('id, title')
				->from('#__content')
				->where('state = 1');
			
			$db->setQuery($query);
			$items = $db->loadObjectList();

			static::$articles = array();
			
			if (!empty($items))
			{
				foreach ($items as $item)
				{
					static::$articles[] = JHTML::_('select.option', (int) $item->id, $item->title);
				}
			}
		}
		
		return array_merge(parent::getOptions(), static::$articles);
	}
}
