<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VirtuePlanet Framework for Joomla!
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

JFormHelper::loadFieldClass('list');

class JFormFieldGFonts extends JFormFieldList
{
	protected $type = 'GFonts';
	
	function getInput()
	{
		$html = parent::getInput();
		$allowUpdate  = !empty($this->element['allowUpdate']) ? $this->element['allowUpdate'] : false;
		
		if ($allowUpdate)
		{
			JHtml::_('jquery.framework');
			$doc = JFactory::getDocument();
			$token = JSession::getFormToken();
			
			$doc->addScriptDeclaration("
			function vpUpdateGFonts(button) {
				var $ = jQuery.noConflict();
				var form = $(button).parents('form');
				var url = form.attr('action');
				$.ajax({
					type: 'GET',
					dataType: 'JSON',
					url: url,
					data: {
						'task': 'style.updateGoogleFonts',
						'{$token}': 1
					},
					success: function(e) {
						console.log(e);
					},
					error: function(e, f, g) {
						console.log(e);
						console.log(f);
						console.log(g);
						form.append(e.responseText);
					}
				});
			}
			");
			
			$html .= '<button type="button" class="btn" onclick="vpUpdateGFonts(this);">Update</button>';
		}

		return $html;
	}
	
	protected function getOptions()
	{
		$options = parent::getOptions();
		$helper  = VPFrameworkAdmin::getInstance();
		$fonts   = $helper->getGoogleFonts(false);
		
		if (empty($fonts))
		{
			return $options;
		}
		
		foreach ($fonts as $font)
		{
			$options[] = JHtml::_('select.option', $font['family'], $font['family']);
		}
		
		return $options;
	}
}