<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VirtuePlanet Framework for Joomla!
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

JFormHelper::loadFieldClass('list');

class JFormFieldVPLayout extends JFormFieldList
{
	protected $type = 'VPLayout';
	
	protected function getOptions()
	{
		$options = parent::getOptions();
		$helper  = VPFrameworkAdmin::getInstance();
		$layouts = $helper->getLayouts();
		
		if (empty($layouts))
		{
			return $options;
		}
		
		foreach ($layouts as $layout)
		{
			$options[] = JHtml::_('select.option', $layout, ucfirst($layout));
		}
		
		return $options;
	}
}