<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VirtuePlanet Framework for Joomla!
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

if (!class_exists('VPFramework\lib\Browser'))
{
	require VPF_PLUGINPATH . '/lib/Browser.php';
}

/**
* VP Framework Browser
* 
* @since 3.0
*/
class VPFrameworkBrowser extends VPFramework\lib\Browser
{
	protected $font_support = null;
	
	protected static $instances = array();

	public static function getInstance($userAgent = "")
	{
		if (empty(self::$instances[$userAgent]))
		{
			self::$instances[$userAgent] = new VPFrameworkBrowser($userAgent);
		}

		return self::$instances[$userAgent];
	}
	
	public function isBrowser($browser)
	{
		$constant = 'self::BROWSER_' . strtoupper($browser);
		
		if (defined($constant) && $this->getBrowser() == constant($constant))
		{
			return true;
		}
		
		return false;
	}
	
	public function getFontSupport($hash = false)
	{
		if ($this->font_support === null)
		{
			$browser = $this->getBrowser();
			$version = $this->getVersion();
			$support = array();
			
			switch($browser)
			{
				case self::BROWSER_OPERA:
					$support[] = 'woff';
					$support[] = 'ttf';
					$support[] = 'svg';
					if ($version > 22)
					{
						$support[] = 'woff2';
					}
					break;
				case self::BROWSER_OPERA_MINI:
					$support[] = 'svg';
					break;
				case self::BROWSER_EDGE:
					$support[] = 'woff';
					break;
				case self::BROWSER_IE:
					$support[] = 'eot';
					if ($version == 11)
					{
						$support[] = 'woff';
						$support[] = 'svg';
					}
					break;
				case self::BROWSER_POCKET_IE:
					$support[] = 'woff';
					$support[] = 'svg';
					break;
				case self::BROWSER_FIREFOX:
					$support[] = 'woff';
					$support[] = 'ttf';
					$support[] = 'svg';
					if ($version == 38)
					{
						$support[] = 'woff2';
					}
					break;
				case self::BROWSER_SAFARI:
					$support[] = 'ttf';
					$support[] = 'svg';
					if ($version >= 5.1)
					{
						$support[] = 'woff';
					}
					break;
				case self::BROWSER_SAFARI:
					$support[] = 'ttf';
					$support[] = 'svg';
					if ($version >= 5.1)
					{
						$support[] = 'woff';
					}
					break;
				case self::BROWSER_IPHONE:
				case self::BROWSER_IPOD:
				case self::BROWSER_IPAD:
					$support[] = 'svg';
					if ($version > 5)
					{
						$support[] = 'woff';
					}
					if ($version > 4.1)
					{
						$support[] = 'ttf';
					}
					break;
				case self::BROWSER_CHROME:
					$support[] = 'woff';
					$support[] = 'ttf';
					$support[] = 'svg';
					if ($version > 36)
					{
						$support[] = 'woff2';
					}
					break;
				case self::BROWSER_ANDROID:
					$support[] = 'ttf';
					if ($version > 4.3)
					{
						$support[] = 'woff';
						$support[] = 'svg';
					}
					break;
				case self::BROWSER_BLACKBERRY:
					$support[] = 'woff';
					$support[] = 'ttf';
					$support[] = 'svg';
					break;
				default:
					$support[] = 'ttf';
			}
			
			if (count($support) > 1)
			{
				asort($support);
				reset($support);
			}
			
			$this->font_support = $support;
		}
		
		if ($hash)
		{
			return md5(serialize($this->font_support));
		}
		
		return $this->font_support;
	}
}