<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VirtuePlanet Framework for Joomla!
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

jimport('joomla.filesystem.folder');
jimport('joomla.filesystem.file');

class VPFrameworkCDN extends JObject
{
	public static $instance = null;
	
	protected $_root = null;
	protected $_processed_files;
	protected $_skipped_files;
	protected $_params;
	protected $_cache_header;
	protected $_optimized_url;
	protected $_optimized_path;
	
	public function __construct()
	{
		$template = plgSystemVPFrameworkHelper::getTemplate();
		$this->_params = $template->params;
		
		$this->_processed_files = array();
		$this->_processed_files['css'] = array();
		$this->_processed_files['js'] = array();
		
		$this->_skipped_files = array();
		$this->_skipped_files['css'] = array();
		$this->_skipped_files['js'] = array();
		
		$this->_cache_header = '<?php die("Access Denied"); ?>';
		$this->_optimized_url = JUri::root(true) . '/media/vpframework/optimized';
		$this->_optimized_path = JPATH_SITE . DIRECTORY_SEPARATOR . 'media' . DIRECTORY_SEPARATOR . 'vpframework' . DIRECTORY_SEPARATOR . 'optimized';
	}
	
	public static function getInstance()
	{
		if (self::$instance === null)
		{
			self::$instance = new VPFrameworkCDN();
		}
		
		return self::$instance;
	}
	
	public function setCDN(&$buffer)
	{
		
		

	}
	
	private function getUrlList()
	{
		// Domain url or root path
		$url = preg_quote(str_replace('https://', 'http://', JURI::root()), '#');
		$url .= '|' . preg_quote(str_replace('http://', '//', JURI::root()), '#');

		if ($this->_params->get('cdn_https', 0))
		{
			$url .= '|' . preg_quote(str_replace('http://', 'https://', JURI::root()), '#');
		}

		if (JUri::root(true))
		{
			$url .= '|' . preg_quote(JURI::root(true) . '/', '#');
		}

		$filetypes = implode('|', $this->params->set->filetypes);
		$root = preg_quote($this->params->set->root, '#');

		$urls = array();

		// Absolute path
		$urls[] = '(?:' . $url . ')' . $root . '([^ \?QUOTES]+\.(?:' . $filetypes . ')(?:\?[^QUOTES]*)?)';
		// Relative path
		$urls[] = 'LSLASH' . $root . '([a-z0-9-_]+/[^ \?QUOTES]+\.(?:' . $filetypes . ')(?:\?[^QUOTES]*)?)';
		// Relative path - file in root
		$urls[] = 'LSLASH' . $root . '([a-z0-9-_]+[^ \?\/QUOTES]+\.(?:' . $filetypes . ')(?:\?[^QUOTES]*)?)';

		return $urls;
	}
}