<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VirtuePlanet Framework for Joomla!
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

class VPFrameworkCompressor 
{
	protected $double_quote     = '"(?>(?:\\\\.)?[^\\\\"]*+)+?(?:"|(?=$))';
	
	protected $single_quote     = "'(?>(?:\\\\.)?[^\\\\']*+)+?(?:'|(?=$))";
	
	protected $comment_block    = '/\*(?>[^/\*]++|//|\*(?!/)|(?<!\*)/)*+\*/';
	
	protected $comment_line     = '//[^\r\n]*+';
	
	protected $debug            = false;
	
	protected $timelimit        = 0;
	
	protected $debug_regex_name = null;
	
	protected $starttime        = 0;
	
	
	public function __construct($debug = false, $timelimit = 0, $debug_regex_name = null)
	{
		$this->debug            = $debug;
		$this->timelimit        = $timelimit;
		$this->debug_regex_name = $debug_regex_name;
	}
	
	public static function getInstance($type, $debug = false, $timelimit = 0, $debug_regex_name = null)
	{
		$type  = strtolower($type);
		$class = 'VPFrameworkCompressor' . ucfirst($type);
		
		if (!class_exists($class))
		{
			$file = dirname(__FILE__) . '/' . $type . '.php';
			
			if (file_exists($file))
			{
				require $file;
			}
		}
		
		if (!class_exists($class))
		{
			throw new Exception($class . ' not found.');
		}
		
		return new $class($debug, $timelimit, $debug_regex_name);
	}
	
	protected function debug($regex, $content, $regex_name = null)
	{
		if (!$this->debug)
		{
			return false;
		}
		
		if ($this->starttime == 0)
		{
			$this->starttime = microtime(true);
		}
		
		$nowtime   = microtime(true);
		$timetaken = $nowtime - $this->starttime;
		
		if ($timetaken > $this->timelimit)
		{
			print 'regex_name=' . $regex_name . PHP_EOL;
			print 'timetaken=' . $timetaken . PHP_EOL;
		}
		
		if ($this->debug_regex_name && $this->debug_regex_name == $regex_name)
		{
			print 'regex=' . $regex . PHP_EOL;
			print 'content=' . $content . PHP_EOL;
		}
		else
		{
			print PHP_EOL;
		}

		$this->starttime = $nowtime;
	}
	
	protected function replace($regex, $replacement, $content, $regex_name = null, $callback = null)
	{
		if (empty($callback) || !is_array($callback))
		{
			$result = preg_replace($regex, $replacement, $content);
		}
		else
		{
			$result = preg_replace_callback($regex, $callback, $content);
		}

		$this->debug($regex, $content, $regex_name);
		
		if (preg_last_error() != PREG_NO_ERROR)
		{
			if (version_compare(PHP_VERSION, '7', '>=') && ini_get('pcre.jit'))
			{
				$error = array_flip(get_defined_constants(true)['pcre'])[preg_last_error()];
				
				JFactory::getApplication()->enqueueMessage($error . ' Disable pcre.jit in PHP settings.');
			}

			throw new \Exception;
		}

		return $result;
	}
	
}