<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VirtuePlanet Framework for Joomla!
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

class VPFrameworkMethod extends JObject
{
	protected $_options;
	
	public static $instances = array();

	
	public function __construct($options = array())
	{
		$this->_options = (array) $options;
	}
	
	public static function getInstance($options = array())
	{
		$options = (array) $options;
		$hash = md5(serialize($options));

		if (isset(self::$instances[$hash]))
		{
			return self::$instances[$hash];
		}

		self::$instances[$hash] = new VPFrameworkMethod($options);
		
		return self::$instances[$hash];
	}
	
	public function route()
	{
		$app = JFactory::getApplication();
		$input = $app->input;
		$uri = $input->get('uri', '', 'BASE64');
		$uri = base64_decode($uri);
		$name = $input->get('name', '', 'CMD');
		$value = $input->get('value', '', 'CMD');

		$url = JRoute::_($uri . '&' . $name . '=' . $value);
		$url = str_replace('&amp;', '&', $url);
		
		return $this->jsonReturn(array('url' => $url));
	}
	
	public function getToken()
	{
		return $this->jsonReturn(array('token' => JSession::getFormToken()));
	}
	
	public function addToCompare()
	{
		$app = JFactory::getApplication();
		$session = JFactory::getSession();
		$template = plgSystemVPFrameworkHelper::getTemplate();
		$params = $template->params;
		$input = $app->input;
		$product_id = $input->getInt('product_id', 0);
		$product_name = $input->getString('product_name', '');
		
		if (empty($product_id) || empty($product_name))
		{
			return $this->jsonReturn(array('error' => 1, 'msg' => JText::_('PLG_SYSTEM_VPFRAMEWORK_COMPARE_PRODUCT_ERROR')));
		}
		
		$products = (array) $session->get('vmcompare', array(), 'vpframework');
		$maxProducts = (int) $params->get('maxCompare', 3);

		$url = null;
		$article_id = (int) $params->get('compare_article_id', 0);
		$Itemid = !empty($article_id) ? $template->getArticleItemid($article_id) : 0;
		$Itemid = !empty($Itemid) ? '&Itemid=' . $Itemid : '';
		
		if (!empty($article_id))
		{
			$url = JRoute::_('index.php?option=com_content&view=article&id=' . $article_id . $Itemid);
			$url = str_replace('&amp;', '&', $url);
		}	
		
		if (in_array($product_id, $products))
		{
			return $this->jsonReturn(array('error' => 0, 'msg' => JText::sprintf('PLG_SYSTEM_VPFRAMEWORK_COMPARE_PRODUCT_EXISTS', urldecode($product_name)), 'url' => $url));
		}
		
		$products[] = $product_id;
		
		if (count($products) > $maxProducts)
		{
			array_shift($products);
		}

		$session->set('vmcompare', $products, 'vpframework');
		
		return $this->jsonReturn(array('error' => 0, 'msg' => JText::sprintf('PLG_SYSTEM_VPFRAMEWORK_COMPARE_PRODUCT_ADDED', urldecode($product_name)), 'url' => $url));
	}
	
	public function removeFromCompare()
	{
		$app = JFactory::getApplication();
		$session = JFactory::getSession();
		$template = plgSystemVPFrameworkHelper::getTemplate();
		$params = $template->params;
		$input = $app->input;
		$post = $input->post;
		$ajax = $post->getInt('ajax', $input->getInt('ajax', 0));
		$product_id = $post->getInt('product_id', $input->getInt('product_id', 0));
		$product_name = $post->getString('product_name', $input->getString('product_name', ''));
		$return = $post->get('return', $input->get('return', '', 'BASE64'), 'BASE64');
		
		$products = (array) $session->get('vmcompare', array(), 'vpframework');

		if (empty($return))
		{
			$article_id = (int) $params->get('compare_article_id', 0);
			$Itemid = !empty($article_id) ? $template->getArticleItemid($article_id) : 0;
			$Itemid = !empty($Itemid) ? '&Itemid=' . $Itemid : '';
			
			if (!empty($article_id))
			{
				$return = JRoute::_('index.php?option=com_content&view=article&id=' . $article_id . $Itemid);
			}
		}
		else
		{
			$return = base64_decode($return);
		}
		
		$return = str_replace('&amp;', '&', $return);
		$msg = '';
		
		if (in_array($product_id, $products))
		{
			$key = array_search($product_id, $products);
			unset($products[$key]);
			$session->set('vmcompare', $products, 'vpframework');
			$msg = JText::sprintf('PLG_SYSTEM_VPFRAMEWORK_COMPARE_PRODUCT_REMOVED', urldecode($product_name));
		}
		
		if ($ajax)
		{
			return $this->jsonReturn(array('error' => 0, 'msg' => $msg, 'url' => $return));
		}
		else
		{
			$app->enqueueMessage($msg);
			$app->redirect($return);
		}
	}
	
	public function clearCompare()
	{
		$app = JFactory::getApplication();
		$session = JFactory::getSession();
		$template = plgSystemVPFrameworkHelper::getTemplate();
		$params = $template->params;
		$input = $app->input;
		$post = $input->post;
		$ajax = $post->getInt('ajax', $input->getInt('ajax', 0));
		$return = $post->get('return', $input->get('return', '', 'BASE64'), 'BASE64');
		
		if (empty($return))
		{
			$article_id = (int) $params->get('compare_article_id', 0);
			$Itemid = !empty($article_id) ? $template->getArticleItemid($article_id) : 0;
			$Itemid = !empty($Itemid) ? '&Itemid=' . $Itemid : '';
			
			if (!empty($article_id))
			{
				$return = JRoute::_('index.php?option=com_content&view=article&id=' . $article_id . $Itemid);
			}
		}
		else
		{
			$return = base64_decode($return);
		}
		
		$return = str_replace('&amp;', '&', $return);
		$msg = '';
		
		$session->set('vmcompare', array(), 'vpframework');
		
		if ($ajax)
		{
			return $this->jsonReturn(array('error' => 0, 'msg' => $msg, 'url' => $return));
		}
		else
		{
			$app->enqueueMessage($msg);
			$app->redirect($return);
		}
	}
	
	public function addToWishlist()
	{
		JSession::checkToken('get') or $this->jsonReturn(array('error' => 1, 'msg' => JText::_('JINVALID_TOKEN')));
		
		$app = JFactory::getApplication();
		$session = JFactory::getSession();
		$db = JFactory::getDbo();
		$template = plgSystemVPFrameworkHelper::getTemplate();
		$params = $template->params;
		$user = JFactory::getUser();
		$user_id = (int) $user->get('id');
		$input = $app->input;
		$product_id = $input->getInt('product_id', 0);
		$product_name = $input->getString('product_name', '');
		$product_name = urldecode($product_name);
		$url = null;
		
		$article_id = (int) $params->get('wishlist_article_id', 1);
		$Itemid = !empty($article_id) ? $template->getArticleItemid($article_id) : 0;
		$Itemid = !empty($Itemid) ? '&Itemid=' . $Itemid : '';
		
		if (!empty($article_id))
		{
			$url = JRoute::_('index.php?option=com_content&view=article&id=' . $article_id . $Itemid);
			$url = str_replace('&amp;', '&', $url);
		}
		
		if (empty($product_id) || empty($product_name))
		{
			return $this->jsonReturn(array('error' => 1, 'msg' => JText::_('PLG_SYSTEM_VPFRAMEWORK_WISHLIST_ERROR')));
		}

		if ($user->guest || empty($user_id))
		{
			if (!$params->get('allow_vm_guest_wishlist', 1))
			{
				$this->jsonReturn(array('error' => 2, 'msg' => JText::_('PLG_SYSTEM_VPFRAMEWORK_WISHLIST_NEED_LOGIN')));
			}
			else
			{
				$itemsInCookie = VPFrameworkVM::getWishlistFromCookie();
				
				$products = (array) $session->get('vmwishlist', $itemsInCookie, 'vpframework');
				
				if (in_array($product_id, $products))
				{
					return $this->jsonReturn(array('error' => 0, 'msg' => JText::sprintf('PLG_SYSTEM_VPFRAMEWORK_WISHLIST_PRODUCT_EXISTS', $product_name), 'url' => $url));
				}
				
				$products[] = $product_id;
				
				$session->set('vmwishlist', $products, 'vpframework');
				VPFrameworkVM::setWishlistToCookie($products);
				
				return $this->jsonReturn(array('error' => 0, 'msg' => JText::sprintf('PLG_SYSTEM_VPFRAMEWORK_WISHLIST_PRODUCT_ADDED_GUEST', $product_name), 'url' => $url));
			}
		}
		
		// Check if already added
		$query = $db->getQuery(true)
								->select('COUNT(virtuemart_product_id)')
								->from($db->quoteName('#__vpframework_vm_wishlist'))
								->where('user_id = ' . (int) $user->get('id'))
								->where('virtuemart_product_id = ' . (int) $product_id);
								
		$db->setQuery($query);
		$exists = $db->loadResult();
		
		if (!empty($exists))
		{
			return $this->jsonReturn(array('error' => 0, 'msg' => JText::sprintf('PLG_SYSTEM_VPFRAMEWORK_WISHLIST_PRODUCT_EXISTS', $product_name), 'url' => $url));
		}
		
		// Add the mapping to the table
		$query->clear()
					->insert($db->quoteName('#__vpframework_vm_wishlist'))
					->columns(array($db->quoteName('user_id'), $db->quoteName('virtuemart_product_id')))	
					->values($user_id . ',' . $product_id);
		
		try 
		{
			$db->setQuery($query);
			$db->execute();
		}
		catch (Exception $e) 
		{
			return $this->jsonReturn(array('error' => 1, 'msg' => $e->getMessage()));
		}
		
		return $this->jsonReturn(array('error' => 0, 'msg' => JText::sprintf('PLG_SYSTEM_VPFRAMEWORK_WISHLIST_PRODUCT_ADDED', $product_name), 'url' => $url));		
	}
	
	public function removeFromWishlist()
	{
		$app = JFactory::getApplication();
		$input = $app->input;
		$post = $input->post;
		$ajax = $post->getInt('ajax', $input->getInt('ajax', 0));
		
		if ($ajax)
		{
			JSession::checkToken('get') or $this->jsonReturn(array('error' => 1, 'msg' => JText::_('JINVALID_TOKEN')));
		}
		else
		{
			JSession::checkToken() or die('Invalid Token');
		}
		
		$user = JFactory::getUser();
		$user_id = (int) $user->get('id');
		$template = plgSystemVPFrameworkHelper::getTemplate();
		$params = $template->params;
		$post = $input->post;
		$product_id = $post->getInt('product_id', $input->getInt('product_id', 0));
		$product_name = $post->getString('product_name', $input->getString('product_name', ''));
		$product_name = urldecode($product_name);
		$return = $post->get('return', $input->get('return', '', 'BASE64'), 'BASE64');	

		if (empty($return))
		{
			$article_id = (int) $params->get('wishlist_article_id', 0);
			$Itemid = !empty($article_id) ? $template->getArticleItemid($article_id) : 0;
			$Itemid = !empty($Itemid) ? '&Itemid=' . $Itemid : '';
			
			if (!empty($article_id))
			{
				$return = JRoute::_('index.php?option=com_content&view=article&id=' . $article_id . $Itemid);				
			}
		}
		else
		{
			$return = base64_decode($return);
		}
		
		$loginPage = JRoute::_('index.php?option=com_users&view=login&return=' . base64_encode($return), false);
		
		if ($user->guest || empty($user_id))
		{
			if (!$params->get('allow_vm_guest_wishlist', 1))
			{
				if ($ajax)
				{
					$this->jsonReturn(array('error' => 2, 'msg' => JText::_('PLG_SYSTEM_VPFRAMEWORK_NEED_LOGIN'), 'url' => $loginPage));
				}
				else
				{
					$app->enqueueMessage(JText::_('PLG_SYSTEM_VPFRAMEWORK_NEED_LOGIN'));
					$app->redirect($loginPage);
					return;
				}
			}
			else
			{
				$session = JFactory::getSession();
				$itemsInCookie = VPFrameworkVM::getWishlistFromCookie();
				$products = (array) $session->get('vmwishlist', $itemsInCookie, 'vpframework');
				$key = array_search($product_id, $products);
				
				if ($key !== false)
				{
					unset($products[$key]);
					$products = array_values($products);
					
					$session->set('vmwishlist', $products, 'vpframework');
					VPFrameworkVM::setWishlistToCookie($products);
				}
				
				if ($ajax)
				{
					return $this->jsonReturn(array('error' => 0, 'msg' => JText::sprintf('PLG_SYSTEM_VPFRAMEWORK_WISHLIST_PRODUCT_REMOVED', $product_name), 'url' => $return));
				}
				else
				{
					$app->enqueueMessage(JText::sprintf('PLG_SYSTEM_VPFRAMEWORK_WISHLIST_PRODUCT_REMOVED', $product_name));
					$app->redirect($return);
					return;
				}
			}
		}
		
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		 
		$conditions = array(
		    $db->quoteName('user_id') . ' = ' . $user_id, 
		    $db->quoteName('virtuemart_product_id') . ' = ' . $product_id
		);
		 
		$query->delete($db->quoteName('#__vpframework_vm_wishlist'));
		$query->where($conditions);
		 
		try 
		{
			$db->setQuery($query);
			$db->execute();
		} 
		catch (Exception $e) 
		{
			if ($ajax)
			{
				return $this->jsonReturn(array('error' => 1, 'msg' => $e->getMessage(), 'url' => $return));
			}
			else
			{
				$app->enqueueMessage($e->getMessage(), 'error');
				$app->redirect($return);
				return;
			}
		}

		if ($ajax)
		{
			return $this->jsonReturn(array('error' => 0, 'msg' => JText::sprintf('PLG_SYSTEM_VPFRAMEWORK_WISHLIST_PRODUCT_REMOVED', $product_name), 'url' => $return));
		}
		else
		{
			$app->enqueueMessage(JText::sprintf('PLG_SYSTEM_VPFRAMEWORK_WISHLIST_PRODUCT_REMOVED', $product_name));
			$app->redirect($return);
		}
	}
	
	public function removeFromCart()
	{
		$app = JFactory::getApplication();
		$input = $app->input;
		$post = $input->post;
		$ajax = $post->getInt('ajax', $input->getInt('ajax', 0));
		$product_id = $post->getInt('cart_virtuemart_product_id', $input->getInt('cart_virtuemart_product_id', 0));
		$product_name = $post->getString('product_name', $input->getString('product_name', ''));
		$product_name = urldecode($product_name);
		
		if (!class_exists('VPFrameworkVM'))
		{
			require(dirname(__FILE__) . '/vm.php');
		}
		
		if (!class_exists('VirtueMartCart'))
		{
			require(JPATH_SITE . '/components/com_virtuemart/helpers/cart.php');
		}
		
		$cart = VirtueMartCart::getCart();
		$return = JRoute::_('index.php?option=com_virtuemart&view=cart');
		
		if (!$cart->removeProductCart($product_id))
		{
			if ($ajax)
			{
				return $this->jsonReturn(array('error' => 1, 'msg' => vmText::_('COM_VIRTUEMART_PRODUCT_NOT_REMOVED_SUCCESSFULLY'), 'url' => $return));
			}
			else
			{
				$app->enqueueMessage(vmText::_('COM_VIRTUEMART_PRODUCT_NOT_REMOVED_SUCCESSFULLY'));
				$app->redirect($return);
				return;
			}
		}
		
		if ($ajax)
		{
			return $this->jsonReturn(array('error' => 0, 'msg' => vmText::_('COM_VIRTUEMART_PRODUCT_REMOVED_SUCCESSFULLY'), 'url' => $return));
		}
		else
		{
			$app->enqueueMessage(vmText::_('COM_VIRTUEMART_PRODUCT_REMOVED_SUCCESSFULLY'), 'success');
			$app->redirect($return);
		}
	}
	
	public function setCookieConsent()
	{
		JSession::checkToken() or $this->jsonReturn(array('error' => 1, 'msg' => JText::_('JINVALID_TOKEN')));
		
		$app           = JFactory::getApplication();
		$conf          = JFactory::getConfig();
		$template      = plgSystemVPFrameworkHelper::getTemplate();
		$params        = $template->params;
		$cookie_domain = $conf->get('cookie_domain', '');
		$cookie_path   = $conf->get('cookie_path', '/');
		$cookieName    = 'vpframework_cookie_consent_' . JUserHelper::getShortHashedUserAgent();
		$cookieName    = version_compare(JVERSION, '4.0.0', 'ge') ? Joomla\CMS\Application\ApplicationHelper::getHash($cookieName) : JApplication::getHash($cookieName);
		$lifetime      = (int) $params->get('cookieconsent_lifetime', 30);
		$lifetime      = $lifetime ? ($lifetime * 24 * 60 * 60) : 0; // Lifetime in seconds
		
		if ($app->isClient('site'))
		{
			$app->input->cookie->set($cookieName, 'accepted', (time() + $lifetime), $cookie_path, $cookie_domain, 0);
			
			$this->jsonReturn(array('error' => 0, 'msg' => 'Done'));
		}
	}
	
	public function getProducts()
	{
		if (!class_exists('VmConfig'))
		{
			require(JPATH_ADMINISTRATOR . '/components/com_virtuemart/helpers/config.php');
		}
		
		VmConfig::loadConfig();
		
		$app   = JFactory::getApplication();
		$db    = JFactory::getDbo();
		$query = $db->getQuery(true);
		
		$like  = trim($app->input->get('like', null));
		$title = trim($app->input->get('title', null));
		
		$query->select('DISTINCT a.`product_name` AS text')
					->select('a.`virtuemart_product_id` AS value')
					->from('`#__virtuemart_products_' . VmConfig::$vmlang . '` AS a')
					->join('LEFT', '`#__virtuemart_products` AS p ON p.`virtuemart_product_id` = a.`virtuemart_product_id`')
					->where($db->quoteName('p.published') . ' = 1')
					->where($db->quoteName('p.product_parent_id') . ' = 0');

		// Search in title or path
		if (!empty($like))
		{
			$query->where($db->quoteName('a.product_name') . ' LIKE ' . $db->quote('%' . $like . '%'));
		}

		// Filter title
		if (!empty($title))
		{
			$query->where($db->quoteName('a.product_name') . ' = ' . $db->quote($title));
		}
		//vpdump(str_replace('#__', 'dg4a5_', $query));exit;
		$db->setQuery($query);
		$result = $db->loadObjectList();
		
		$this->jsonReturn($result);
	}
	
	
	private function jsonReturn($output = array()) 
	{
		return VPFrameworkUtility::jsonReturn($output);
	}
}
