<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VirtuePlanet Framework for Joomla!
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

JLoader::register('VmConfig', JPATH_ROOT . '/administrator/components/com_virtuemart/helpers/config.php');
JLoader::register('VmImage', JPATH_ROOT . '/administrator/components/com_virtuemart/helpers/image.php');
JLoader::register('TableMedias', JPATH_ROOT . '/administrator/components/com_virtuemart/tables/medias.php');

class VPFrameworkVMImage extends JObject
{
	public $media_attributes;
	public $setRole;
	public $file_name;
	public $file_extension;
	public $virtuemart_media_id;
	public $theme_url;
	public $virtuemart_vendor_id;
	public $file_title;
	public $file_description;
	public $file_meta;
	public $file_mimetype;
	public $file_type;
	public $file_url;
	public $file_url_thumb;
	public $published;
	public $file_is_downloadable;
	public $file_is_forSale;
	public $file_is_product_image;
	public $shared;
	public $file_params;
	public $file_lang;
	public $created_on;
	public $created_by;
	public $modified_on;
	public $modified_by;
	public $file_url_folder;
	public $file_path_folder;
	public $file_url_folder_thumb;
	public $media_role;
	
	protected $_object;
	
	public function __construct($image)
	{
		if ($image)
		{
			$this->_object = $image;
			$this->setProperties($image);
			return true;
		}
		
		return false;
	}
	
	public function set($property, $value = null)
	{
		if (property_exists($this, $property))
		{
			$previous = isset($this->$property) ? $this->$property : null;
			$this->$property = $value;
			return $previous;
		}
	}
	
	public function getFull($fallback_alt = '')
	{
		if (!$this->file_is_forSale)
		{
			if ( substr( $this->file_url, 0, 4) == "http" )
			{
				$file_url = $this->file_url;
				$file_alt = $this->file_title;
			} 
			else 
			{
				$rel_path = str_replace('/', DS, $this->file_url_folder);
				$fullSizeFilenamePath = VMPATH_ROOT . DS . $rel_path . $this->file_name . '.' . $this->file_extension;
				
				if (!is_file($fullSizeFilenamePath) || !file_exists($fullSizeFilenamePath)) 
				{
					$file_url = $this->theme_url. 'assets/images/vmgeneral/' . VmConfig::get('no_image_found');
					$file_alt = vmText::_('COM_VIRTUEMART_NO_IMAGE_FOUND') . ' ' . (!empty($this->file_description) ? $this->file_description : $fallback_alt);
				} 
				else 
				{
					$file_url = $this->file_url;
					$file_alt = !empty($this->file_meta) ? $this->file_meta : $fallback_alt;
				}
			}
			
			return array('url' => $this->getClean($file_url), 'alt' => $file_alt);
		} 
		else 
		{
			return $this->getThumb();
		}
	}
	
	public function getThumb($fallback_alt = '')
	{
		if (empty($this->file_name))
		{
			if ($this->file_is_downloadable)
			{
				$file_url = $this->theme_url . 'assets/images/vmgeneral/' . VmConfig::get('downloadable','zip.png');
				$file_alt = vmText::_('COM_VIRTUEMART_NO_IMAGE_SET') . ' ' . (!empty($this->file_description) ? $this->file_description : $fallback_alt);
			} 
			else 
			{
				$file_url = $this->theme_url . 'assets/images/vmgeneral/' . VmConfig::get('no_image_set');
				$file_alt = vmText::_('COM_VIRTUEMART_NO_IMAGE_SET') . ' ' . (!empty($this->file_description) ? $this->file_description : $fallback_alt);
			}
			return array('url' => $this->getClean($file_url), 'alt' => $file_alt);
		}

		if (!empty($this->file_url_thumb))
		{
			$file_url_thumb = $this->file_url_thumb;
		} 
		elseif (is_a($this->_object,'VmImage')) 
		{
			$file_url_thumb = $this->_object->createThumbFileUrl();
		} 
		else 
		{
			$file_url_thumb = '';
		}

		$media_path = VMPATH_ROOT . DS . str_replace('/', DS, $file_url_thumb);

		if (empty($this->file_meta))
		{
			if (!empty($this->file_description))
			{
				$file_alt = $this->file_description;
			} 
			else if (!empty($this->file_name)) 
			{
				$file_alt = $this->file_name;
			} 
			else 
			{
				$file_alt = $fallback_alt;
			}
		} 
		else 
		{
			$file_alt = !empty($this->file_meta) ? $this->file_meta : $fallback_alt;
		}

		if ((empty($file_url_thumb) || !is_file($media_path) || !file_exists($media_path)) && is_a($this->_object,'VmImage')) 
		{
			$width = VmConfig::get('img_width', 90);
			$height = VmConfig::get('img_height', 90);
			$file_url_thumb = (string) $this->_object->createThumb($width, $height);
			$media_path = VMPATH_ROOT . DS . str_replace('/', DS, $file_url_thumb);
		}
		
		$this->file_url_thumb = $file_url_thumb;

		if (empty($this->file_url_thumb) || !file_exists($media_path)) 
		{
			return $this->getIcon($fallback_alt);
		}

		return array('url' => $this->getClean($file_url_thumb), 'alt' => $file_alt);
	}
	
	function getIcon($fallback_alt = '')
	{
		if (!empty($this->file_extension))
		{
			$file_url = $this->theme_url . 'assets/images/vmgeneral/filetype_' . $this->file_extension . '.png';
			$file_alt = !empty($this->file_description) ? $this->file_description : $fallback_alt;
		} 
		else 
		{
			$file_url = $this->theme_url . 'assets/images/vmgeneral/' . VmConfig::get('no_image_found');
			$file_alt = vmText::_('COM_VIRTUEMART_NO_IMAGE_FOUND') . ' ' . (!empty($this->file_description) ? $this->file_description : $fallback_alt);
		}
		
		return array('url' => $this->getClean($file_url), 'alt' => $file_alt);
	}
	
	function getClean($file_url)
	{
		$file_url = trim($file_url);
		
		if ($file_url && pathinfo($file_url, PATHINFO_EXTENSION) && substr($file_url, 0, 4) != "http")
		{
			$file_url = JURI::root(true) . '/' . $file_url;
		}
		
		return $file_url; 
	}
}
