<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

$template          = plgSystemVPFrameworkHelper::getTemplate();
$app               = JFactory::getApplication();
$doc               = JFactory::getDocument();
$browser           = VPFrameworkBrowser::getInstance();
$tab               = $doc->_getTab();
$lineEnd           = $doc->_getLineEnd();
$user              = JFactory::getUser();
$this->language    = $doc->language;
$this->direction   = $doc->direction;
$params            = $template->params;
$this->params      = $params;
$version           = !empty($template->xml->version) ? $template->xml->version : 'unknown';
$headers           = function_exists('getallheaders') ? getallheaders() : array();
$isMinimal         = isset($headers['Ajax-Request']) && $headers['Ajax-Request'] == 'active' ? true : false;
$cacheConfig       = JFactory::getConfig()->get('caching');

if($isMinimal && (($cacheConfig != 0 && $cacheConfig != 1) || JPluginHelper::isEnabled('system', 'cache')))
{
	$isMinimal = false;
}

// Detecting Active Variables
$option           = $app->input->getCmd('option', '');
$view             = $app->input->getCmd('view', '');
$layout           = $app->input->getCmd('layout', '');
$task             = $app->input->getCmd('task', '');
$print            = $app->input->getInt('print', 0);
$itemid           = $app->input->getCmd('Itemid', '');
$tmpl             = $app->input->getCmd('tmpl', '');
$sitename         = $app->get('sitename');
$responsive       = $params->get('responsive', 1);

$htmlClass        = ($responsive ? 'responsive' : 'unresponsive') .
                    ($option ? ' ' . str_replace('_', '-', $option) : '') .
                    ($view ? ' view-' . $view : 'no-view') .
                    ($layout ? ' layout-' . $layout : ' no-layout') .
                    ($task ? ' task-' . $task : ' no-task') . 
                    ($tmpl ? ' tmpl-' . $tmpl : '') .
                    ($itemid ? ' itemid-' . $itemid : '') . 
                    ($version ? ' version-' . $version : '') . 
                    (' joomla-' . substr(JVERSION, 0, 1));

$items            = $params->get('fullwidth', array());
$itemids          = (array) $params->get('fullwidth_itemid', array());
$isFullWidth      = false;
$options          = array();
$views            = array();
$layouts          = array();

if(!empty($items))
{
	if(is_string($items))
	{
		if(strpos($items, ','))
		{
			$items = explode(',', $items);
			$items = array_map('trim', $items);
		}
		else
		{
			$items = array($items);
		}
	}
	foreach($items as &$item)
	{
		$item = json_decode(base64_decode($item), true);
		$options[] = $item['option'];
		$views[] = $item['view'];
		$layouts[] = $item['layout'];
	}
}

if(in_array($option, $options) && in_array($view, $views) && in_array($layout, $layouts))
{
	$isFullWidth = true;
}
elseif(in_array($itemid, $itemids))
{
	$isFullWidth = true;
}

// Ajax update token option
VPFrameworkScript::addOption('UPDATE_TOKEN', (int) $params->get('ajax_update_token', 0));

// Lets load the template layouts
require $template->getStructure(__FILE__);