<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

// Is it VirtueMart Product Page
$isVMProductPage = ($option == 'com_virtuemart' && $view == 'productdetails');

// Load mandatory VP Framwork libraries which includes Bootstrap and other utilities like icons.css, animate.css etc
$template->loadFramework($responsive);

// Load all other required libraries and javascripts. Respective css files, if exists, also will be loaded.
$_jsLibraries = array(
	'bootstrap-dialog.min', 'bootstrap-select.min', 'jquery.easing.min',
	'jquery.hoverIntent.min', 'jquery.lazyload.min', 'jquery.raty.min',
	'jquery.waitforimages.min', 'jquery.equalheight.min', 'jquery.owl.carousel.min',
	'scrollreveal.min'
);

if ($this->params->get('responsive', 1))
{
	if ($this->params->get('offcavas', 1) && $tmpl != 'component' && $tmpl != 'error')
	{
		$_jsLibraries[] = 'jquery.nanoscroller.min';
		$_jsLibraries[] = 'jquery.mmenu.all.min';
	}
	
	$doc->setMetaData('X-UA-Compatible', 'IE=edge', true);
	$doc->setMetaData('HandheldFriendly', 'true', false);
	$doc->setMetaData('apple-touch-fullscreen', 'yes', false);
	$doc->setMetaData('viewport', 'width=device-width, initial-scale=1.0', false);
}

if ($isVMProductPage)
{
	$_jsLibraries[] = 'jquery.imagelightbox.min';
	$_jsLibraries[] = 'jquery.imagelightbox.helper.min';
	
	if ($params->get('vpf_zoom_enabled', 1))
	{
		$_jsLibraries[] = 'jquery.cloudzoom.modified.min';
	}
	else
	{
		$_jsLibraries[] = 'jquery.simplegallery.min';
	}
}

// Load all required JS libraries
$template->loadJSLibraries($_jsLibraries);

// Load all template javascripts
if ($tmpl != 'component' && $tmpl != 'error')
{
	$template->addStylesheet('menu.css', $version);
	$template->addScript('menu.min.js', $version);
	
	if ($this->params->get('megamenu', 1))
	{
		$template->addStylesheet('megamenu.css', $version);
		$template->addScript('megamenu.min.js', $version);
	}
	
	if ($this->params->get('offcavas', 1) && $this->params->get('responsive', 1))
	{
		$template->addStylesheet('offcanvas.css', $version);
		$template->addScript('offcanvas.min.js', $version);
	}
}

// If VirtueMart Product Page
if ($isVMProductPage)
{
	$template->addStylesheet('virtuemart-imagegallery.css', $version);
}

$template->addStylesheet('virtuemart.css', $version);
$template->addStylesheet('template.css', $version);

if ($print)
{
	$doc->addStyleSheet($template->uri . '/css/print.css?v=' . $version, array('type' => 'text/css', 'media' => 'print'));
}

if ($responsive)
{
	$template->addStylesheet('template-responsive.css', $version);
	$template->addStylesheet('virtuemart-responsive.css', $version);
}

// Load main template JavaScripts
$template->addScript('template.min.js', $version);

$doc->addScriptDeclaration('var sr = window.sr || ScrollReveal();');

// Do we need to load Google Fonts
if ($params->get('useGoogleFont', 0) == 1)
{
	$fontCSS = array();
	
	if ($params->get('googleFontName', ''))
	{
		$fontName       = $this->params->get('googleFontName', '');
		$fontVariant    = $this->params->get('googleFontVariant', '');
		$fontSubsets    = $this->params->get('googleFontSubsets', array());
		
		$template->addGoogleFontFamily($fontName, $fontVariant, $fontSubsets);
		
		$fontCSS[] = $template->getGoogleFontCSS('body', $fontName, $fontVariant, 'Verdana');
	}
	
	if ($params->get('header_googleFontName', ''))
	{
		$fontName       = $this->params->get('header_googleFontName', '');
		$fontVariant    = $this->params->get('header_googleFontVariant', '');
		$fontSubsets    = $this->params->get('header_googleFontSubsets', array());
		
		$template->addGoogleFontFamily($fontName, $fontVariant, $fontSubsets);
		
		$fontCSS[] = $template->getGoogleFontCSS('header', $fontName, $fontVariant, 'Verdana');
	}
	
	if (!empty($fontCSS) && ($google_font_url = $template->getGoogleFontUrl()))
	{
		// Optimize font loading
		$doc->addHeadLink('//fonts.gstatic.com', 'dns-prefetch');
		
		// Load Google font
		$doc->addStyleSheet($google_font_url);
		
		// Build css string
		$fontCSS = implode($lineEnd, $fontCSS) . $lineEnd;
		
		// Add CSS to use Google font family
		$doc->addStyleDeclaration($fontCSS);
	}
}
elseif ($params->get('useGoogleFont', 0) == 0)
{
		$dns_url  = '//fonts.gstatic.com';
		$font_url = '//fonts.googleapis.com/css?family=Open+Sans:400,400i,700,700i';
		$scheme   = VPFrameworkUrl::getInstance()->getScheme();
		
		if ($scheme == 'http' || $scheme == 'https')
		{
			$font_url = $scheme . ':' . $font_url;
			$dns_url  = $scheme . ':' . $dns_url;
		}
		
		// Optimize font loading
		$doc->addHeadLink($dns_url, 'dns-prefetch');
		
		// Load default Google font
		$doc->addStyleSheet(htmlspecialchars($font_url, ENT_COMPAT, 'UTF-8'));
}

// Check for Internet Explorer
$msie = $browser->isBrowser('IE');

// Include IE warning script
if ($msie && $params->get('show_ie8_alert', 1))
{
	$ie8Warning = '
  <!--[if lt IE 9]>
    <script src="' . $template->media_uri . '/js/ie8-responsive-file-warning.js"></script>
  <![endif]-->';
  $doc->addCustomTag($ie8Warning);
}

// Include IE Emulation Modes Warning script
if ($msie && $params->get('show_ie_emulation_alert', 1))
{
	$ieEmulationWarning = '
  <!--[if IE]>
    <script src="' . $template->media_uri . '/js/ie-emulation-modes-warning.js"></script>
  <![endif]-->';
  $doc->addCustomTag($ieEmulationWarning);
}

if ($msie)
{
	// For old IE browsers to support HTML5
	$forOldIE = '
  <!--[if lt IE 9]>
    <script src="' . $template->media_uri . '/js/html5shiv.min.js"></script>
    <script src="' . $template->media_uri . '/js/respond.min.js"></script>
  <![endif]-->';
	$doc->addCustomTag($forOldIE);
}

// Load language for Select Picker Script
JText::script('TPL_VP_SMART_SELECTPICKER_NOTHING_SELECTED');
JText::script('TPL_VP_SMART_SELECTPICKER_NO_RESULT');
JText::script('TPL_VP_SMART_SELECTPICKER_ITEM_SELECTED');
JText::script('TPL_VP_SMART_SELECTPICKER_N_ITEMS_SELECTED');
JText::script('TPL_VP_SMART_SELECTPICKER_ITEM_LIMIT_REACHED');
JText::script('TPL_VP_SMART_SELECTPICKER_N_ITEMS_LIMIT_REACHED');
JText::script('TPL_VP_SMART_SELECTPICKER_GROUP_ITEM_LIMIT_REACHED');
JText::script('TPL_VP_SMART_SELECTPICKER_GROUP_N_ITEMS_LIMIT_REACHED');
JText::script('TPL_VP_SMART_SELECTPICKER_SELECT_ALL');
JText::script('TPL_VP_SMART_SELECTPICKER_DESELECT_ALL');
JText::script('TPL_VP_SMART_SELECTPICKER_SEPARATOR');
JText::script('PLG_SYSTEM_VPFRAMEWORK_ITEM_ADDED');
?>
<head>
	<jdoc:include type="head" />
</head>
