<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

$sitename = $params->get('sitetitle') ? $params->get('sitetitle') : $app->getCfg('sitename');

$logo = '';
$desktopLogoClass = '';
$tabletLogoClass = ' visible-xs visible-sm';

if($params->get('logoFileMobile'))
{
	$logo .= '<img class="site-logo logo-mobile visible-xs img-responsive" src="' . JUri::root() . $template->getLogoImage($params->get('logoFileMobile')) . '" alt="' . $sitename . '" />';
	$desktopLogoClass = ' visible-sm visible-md visible-lg';
	$tabletLogoClass = ' visible-sm';
}

if($params->get('logoFileTablet'))
{
	$logo .= '<img class="site-logo logo-tablet img-responsive' . $tabletLogoClass . '" src="' . JUri::root() . $template->getLogoImage($params->get('logoFileTablet')) . '" alt="' . $sitename . '" />';
	$desktopLogoClass = ' visible-md visible-lg';
}

if($params->get('logoFile'))
{
	$logo .= '<img class="site-logo logo-general img-responsive' . $desktopLogoClass . '" src="' . JUri::root() . $template->getLogoImage($params->get('logoFile')) . '" alt="' . $sitename . '" />';
}
else
{
	$logo .= '<span class="site-logo-text logo-general' . $desktopLogoClass . '" title="' . $sitename . '">' . $sitename . '</span>';
}

$logo_grid = (int) $params->get('logo_grid', 3);
$nav_grid = (int) $params->get('nav_grid', 6);
$module_grid = (int) $params->get('headermodule_grid', 3);

if(($logo_grid + $nav_grid + $module_grid) != 12) 
{
	$app->enqueueMessage('Header Layout Grid Sizes are not correctly set in the template settings. The total of 3 grids must be equal to 12.');
}
elseif(!$this->countModules('mini-cart') && !$this->countModules('compare') && !$this->countModules('wishlist') && !$this->countModules('search'))
{
	$nav_grid = ($nav_grid + $module_grid);
	$module_grid = 0;
}

$logo_class = !empty($logo_grid) ? 'col-md-' . $logo_grid : 'hidden-md hidden-lg';
$nav_class = !empty($nav_grid) ? 'col-md-' . $nav_grid : 'hidden-md hidden-lg';
$module_class = !empty($module_grid) ? 'col-md-' . $module_grid : 'hidden-md hidden-lg';
$module_inner_class = !empty($module_grid) ? '' : ' hidden-xs';
?>
<header id="vpf-header"<?php echo $params->get('mega_fixed_on_scroll', 1) ? ' class="affix-on-scroll"' : ''; ?>>
	<div class="header-top">
		<div class="container-fluid">
			<div class="inner-container">
				<div class="row row-condensed">
					<div class="<?php echo $logo_class ?> vpf-logo col-sm-11 col-xs-11">
						<a class="brand" href="<?php echo $this->baseurl; ?>/"><?php echo $logo; ?></a>
					</div>
					<?php if($this->params->get('responsive', 1) && $this->params->get('offcavas', 1)) : ?>
					<div class="offcanvas-toggle-container hidden-lg hidden-md">
						<a class="btn navbar-toggle vpf-offcanvas-toggle" href="#vpf-offcanvas">
							<span class="sr-only">Toggle menu</span>
							<i class="fa fa-bars fa-2x"></i>
						</a>
					</div>
					<?php endif; ?>
					<?php if($this->params->get('megamenu', 1)) : ?>
						<div class="<?php echo $nav_class ?> header-add-margin hidden-sm hidden-xs">
							<nav class="navbar navbar-mainmenu visible-md-block visible-lg-block vpf-mainmenu" role="navigation">
								<div class="collapse navbar-collapse vpf-mega-menu-container">
									<?php echo $template->getMenu(); ?>
								</div>
							</nav>
						</div>
					<?php endif; ?>
					<div class="<?php echo $module_class ?> last-group">
						<div class="navbar navbar-offcanvas">
							<?php if($this->countModules('search') || $this->countModules('mini-cart') || $this->countModules('compare') || $this->countModules('wishlist')) : ?>
							<div class="navbar-offcanvas-modules align-right<?php echo $module_inner_class ?>" data-align="check">
								<?php if($this->countModules('search')) : ?>
									<div class="search-mod-icon inline-block header-add-margin">
										<a href="#" class="color-base show-header-search"><i class="fa fa-smart-search fa-2x"></i></a>
									</div>
								<?php endif; ?>
								<?php if($this->countModules('wishlist')) : ?>
									<div class="wishlist-mod inline-block header-add-margin">
										<jdoc:include type="modules" name="wishlist" style="none" />
									</div>
								<?php endif; ?>
								<?php if($this->countModules('compare')) : ?>
									<div class="compare-mod inline-block header-add-margin">
										<jdoc:include type="modules" name="compare" style="none" />
									</div>
								<?php endif; ?>
								<?php if($this->countModules('mini-cart')) : ?>
									<div class="mini-cart-mod inline-block header-add-margin">
										<jdoc:include type="modules" name="mini-cart" style="none" />
									</div>
								<?php endif; ?>
								<?php if($this->params->get('show_scroll_to_top', 1)) : ?>
									<div class="scroll-to-top-cont inline-block hidden-md hidden-lg">
										<a href="#" class="scroll-to-top-sm color-base" data-scroll="top">
											<span class="sr-only"><?php echo JText::_('PLG_SYSTEM_VPFRAMEWORK_SCROLL_TOP_TOP') ?></span><i class="fa fa-angle-double-up fa-2x"></i>
										</a>
										<a href="#" class="scroll-to-bottom-sm color-base" data-scroll="bottom">
											<span class="sr-only"><?php echo JText::_('PLG_SYSTEM_VPFRAMEWORK_SCROLL_TO_BOTTOM') ?></span><i class="fa fa-angle-double-down fa-2x"></i>
										</a>
									</div>
								<?php endif; ?>
							</div>
							<?php endif; ?>
						</div>
					</div>
				</div>
			</div>
		</div>
		<?php if($this->countModules('search')) : ?>
			<div class="header-search">
				<div class="header-search-inner<?php echo $this->params->get('search_input_style', 'full') == 'small' ? ' search-small': ''; ?>">
					<jdoc:include type="modules" name="search" style="none" />
					<a href="#" class="close-header-search light-link pull-right"><i class="fa fa-smart-cross fa-2x"></i></a>
				</div>
			</div>
		<?php endif; ?>
	</div>
</header>