<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers');

if (!version_compare(JVERSION, '4.0.0', 'ge'))
{
	JHtml::_('behavior.caption');
}

$template = plgSystemVPFrameworkHelper::getTemplate();
?>
<div class="archive<?php echo $this->pageclass_sfx;?>">
	<?php if ($this->params->get('show_page_heading', 1) && !$template->showPageHeadingInBreadcrumbs()) : ?>
		<div class="page-header">
			<h1><?php echo $this->escape($this->params->get('page_heading')); ?></h1>
		</div>
	<?php endif; ?>
	<form id="adminForm" action="<?php echo JRoute::_('index.php')?>" method="post" class="form-inline old-form">
		<fieldset class="filters">
		<div class="filter-search">
			<?php if ($this->params->get('filter_field') != 'hide') : ?>
			<div class="form-group">
				<label class="filter-search-lbl sr-only" for="filter-search"><?php echo JText::_('COM_CONTENT_TITLE_FILTER_LABEL').'&#160;'; ?></label>
				<input type="text" name="filter-search" id="filter-search" value="<?php echo $this->escape($this->filter); ?>" class="form-control" onchange="document.getElementById('adminForm').submit();" placeholder="<?php echo JText::_('COM_CONTENT_TITLE_FILTER_LABEL'); ?>" />
			</div>
			<?php endif; ?>
			<div class="form-group">
				<?php echo $this->form->monthField; ?>
			</div>
			<div class="form-group">
				<?php echo $this->form->yearField; ?>
			</div>
			<div class="form-group">
				<?php echo $this->form->limitField; ?>
			</div>
			<button type="submit" class="btn btn-base"><?php echo JText::_('JGLOBAL_FILTER_BUTTON'); ?></button>
			<input type="hidden" name="view" value="archive" />
			<input type="hidden" name="option" value="com_content" />
			<input type="hidden" name="limitstart" value="0" />
		</div>
		<br />
		</fieldset>

		<?php echo $this->loadTemplate('items'); ?>
	</form>
</div>
