<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;

$global = VPFrameworkGlobal::getInstance();

if (!version_compare(JVERSION, '4.0.0', 'ge'))
{
	JHtml::_('behavior.tabstate');
	JHtml::_('behavior.keepalive');
	JHtml::_('behavior.calendar');
	JHtml::_('behavior.formvalidator');
	JHtml::_('formbehavior.chosen', '.article-edit-page select');
	JHtml::_('behavior.modal', 'a.modal_jform_contenthistory');
	
	JFactory::getDocument()->addScriptDeclaration("
		Joomla.submitbutton = function(task)
		{
			if (task == 'article.cancel' || document.formvalidator.isValid(document.getElementById('adminForm')))
			{
				" . $this->form->getField('articletext')->save() . "
				Joomla.submitform(task);
			}
		}
	");
	
	$format = array('labelClass' => 'control-label col-sm-2', 'fieldClass' => 'col-sm-10');

	$global->setState('form.renderfields.format', $format);
}
else
{
	/** @var Joomla\CMS\WebAsset\WebAssetManager $wa */
	$wa = $this->document->getWebAssetManager();
	$wa->useScript('keepalive')
		->useScript('form.validate')
		->useScript('com_content.form-edit');

	$this->tab_name         = 'com-content-form';
	$this->ignore_fieldsets = array('image-intro', 'image-full', 'jmetadata', 'item_associations');
	$this->useCoreUI        = true;
}

// Create shortcut to parameters.
$params = $this->state->get('params');

// This checks if the editor config options have ever been saved. If they haven't they will fall back to the original settings.
$editoroptions = isset($params->show_publishing_options);

if (!$editoroptions)
{
	$params->show_urls_images_frontend = '0';
}
?>
<?php if (version_compare(JVERSION, '4.0.0', 'ge')) : ?>
	<div class="edit item-page">
		<?php if ($params->get('show_page_heading')) : ?>
		<div class="page-header">
			<h1>
				<?php echo $this->escape($params->get('page_heading')); ?>
			</h1>
		</div>
		<?php endif; ?>

		<form action="<?php echo Route::_('index.php?option=com_content&a_id=' . (int) $this->item->id); ?>" method="post" name="adminForm" id="adminForm" class="form-validate form-vertical">
			<fieldset class="mb-4">
				<?php echo HTMLHelper::_('uitab.startTabSet', $this->tab_name, ['active' => 'editor', 'recall' => true, 'breakpoint' => 768]); ?>

				<?php echo HTMLHelper::_('uitab.addTab', $this->tab_name, 'editor', JText::_('COM_CONTENT_ARTICLE_CONTENT')); ?>
					<?php echo $this->form->renderField('title'); ?>

					<?php if (is_null($this->item->id)) : ?>
						<?php echo $this->form->renderField('alias'); ?>
					<?php endif; ?>

					<?php echo $this->form->renderField('articletext'); ?>

					<?php if ($this->captchaEnabled) : ?>
						<?php echo $this->form->renderField('captcha'); ?>
					<?php endif; ?>
				<?php echo HTMLHelper::_('uitab.endTab'); ?>

				<?php if ($params->get('show_urls_images_frontend')) : ?>
				<?php echo HTMLHelper::_('uitab.addTab', $this->tab_name, 'images', JText::_('COM_CONTENT_IMAGES_AND_URLS')); ?>
					<?php echo $this->form->renderField('image_intro', 'images'); ?>
					<?php echo $this->form->renderField('image_intro_alt', 'images'); ?>
					<?php echo $this->form->renderField('image_intro_alt_empty', 'images'); ?>
					<?php echo $this->form->renderField('image_intro_caption', 'images'); ?>
					<?php echo $this->form->renderField('float_intro', 'images'); ?>
					<?php echo $this->form->renderField('image_fulltext', 'images'); ?>
					<?php echo $this->form->renderField('image_fulltext_alt', 'images'); ?>
					<?php echo $this->form->renderField('image_fulltext_alt_empty', 'images'); ?>
					<?php echo $this->form->renderField('image_fulltext_caption', 'images'); ?>
					<?php echo $this->form->renderField('float_fulltext', 'images'); ?>
					<?php echo $this->form->renderField('urla', 'urls'); ?>
					<?php echo $this->form->renderField('urlatext', 'urls'); ?>
					<div class="control-group">
						<div class="controls">
							<?php echo $this->form->getInput('targeta', 'urls'); ?>
						</div>
					</div>
					<?php echo $this->form->renderField('urlb', 'urls'); ?>
					<?php echo $this->form->renderField('urlbtext', 'urls'); ?>
					<div class="control-group">
						<div class="controls">
							<?php echo $this->form->getInput('targetb', 'urls'); ?>
						</div>
					</div>
					<?php echo $this->form->renderField('urlc', 'urls'); ?>
					<?php echo $this->form->renderField('urlctext', 'urls'); ?>
					<div class="control-group">
						<div class="controls">
							<?php echo $this->form->getInput('targetc', 'urls'); ?>
						</div>
					</div>
				<?php echo HTMLHelper::_('uitab.endTab'); ?>
				<?php endif; ?>

				<?php echo LayoutHelper::render('joomla.edit.params', $this); ?>

				<?php echo HTMLHelper::_('uitab.addTab', $this->tab_name, 'publishing', JText::_('COM_CONTENT_PUBLISHING')); ?>

					<?php echo $this->form->renderField('transition'); ?>
					<?php echo $this->form->renderField('state'); ?>
					<?php echo $this->form->renderField('catid'); ?>
					<?php echo $this->form->renderField('tags'); ?>
					<?php echo $this->form->renderField('note'); ?>
					<?php if ($params->get('save_history', 0)) : ?>
						<?php echo $this->form->renderField('version_note'); ?>
					<?php endif; ?>
					<?php if ($params->get('show_publishing_options', 1) == 1) : ?>
						<?php echo $this->form->renderField('created_by_alias'); ?>
					<?php endif; ?>
					<?php if ($this->item->params->get('access-change')) : ?>
						<?php echo $this->form->renderField('featured'); ?>
						<?php if ($params->get('show_publishing_options', 1) == 1) : ?>
							<?php echo $this->form->renderField('featured_up'); ?>
							<?php echo $this->form->renderField('featured_down'); ?>
							<?php echo $this->form->renderField('publish_up'); ?>
							<?php echo $this->form->renderField('publish_down'); ?>
						<?php endif; ?>
					<?php endif; ?>
					<?php echo $this->form->renderField('access'); ?>
					<?php if (is_null($this->item->id)) : ?>
						<div class="control-group">
							<div class="control-label">
							</div>
							<div class="controls">
								<?php echo JText::_('COM_CONTENT_ORDERING'); ?>
							</div>
						</div>
					<?php endif; ?>
				<?php echo HTMLHelper::_('uitab.endTab'); ?>

				<?php if (Multilanguage::isEnabled()) : ?>
					<?php echo HTMLHelper::_('uitab.addTab', $this->tab_name, 'language', JText::_('JFIELD_LANGUAGE_LABEL')); ?>
						<?php echo $this->form->renderField('language'); ?>
					<?php echo HTMLHelper::_('uitab.endTab'); ?>
				<?php else: ?>
					<?php echo $this->form->renderField('language'); ?>
				<?php endif; ?>

				<?php if ($params->get('show_publishing_options', 1) == 1) : ?>
					<?php echo HTMLHelper::_('uitab.addTab', $this->tab_name, 'metadata', JText::_('COM_CONTENT_METADATA')); ?>
						<?php echo $this->form->renderField('metadesc'); ?>
						<?php echo $this->form->renderField('metakey'); ?>
					<?php echo HTMLHelper::_('uitab.endTab'); ?>
				<?php endif; ?>

				<?php echo HTMLHelper::_('uitab.endTabSet'); ?>

				<input type="hidden" name="task" value="">
				<input type="hidden" name="return" value="<?php echo $this->return_page; ?>">
				<?php echo HTMLHelper::_('form.token'); ?>
			</fieldset>
			<div class="mb-2">
				<button type="button" class="btn btn-primary" data-submit-task="article.save">
					<span class="icon-check" aria-hidden="true"></span>
					<?php echo JText::_('JSAVE'); ?>
				</button>
				<?php if ($this->showSaveAsCopy) : ?>
					<button type="button" class="btn btn-primary" data-submit-task="article.save2copy">
						<span class="icon-copy" aria-hidden="true"></span>
						<?php echo JText::_('JSAVEASCOPY'); ?>
					</button>
				<?php endif; ?>
				<button type="button" class="btn btn-danger" data-submit-task="article.cancel">
					<span class="icon-times" aria-hidden="true"></span>
					<?php echo JText::_('JCANCEL'); ?>
				</button>
				<?php if ($params->get('save_history', 0) && $this->item->id) : ?>
					<?php echo $this->form->getInput('contenthistory'); ?>
				<?php endif; ?>
			</div>
		</form>
	</div>
<?php else: ?>
	<div class="edit article-edit-page item-page<?php echo $this->pageclass_sfx; ?>">
		<?php if ($params->get('show_page_heading', 1)) : ?>
			<div class="page-header">
				<h1><?php echo $this->escape($params->get('page_heading')); ?></h1>
			</div>
		<?php endif; ?>

		<form action="<?php echo JRoute::_('index.php?option=com_content&a_id=' . (int) $this->item->id); ?>" method="post" name="adminForm" id="adminForm" class="form-validate form-horizontal old-form">
			<div class="edit-page-toolbar clearfix">
				<div class="btn-group">
					<button type="button" class="btn btn-success" onclick="Joomla.submitbutton('article.save')">
						<span class="icon-checkmark"></span> <?php echo JText::_('JSAVE') ?>
					</button>
				</div>
				<div class="btn-group">
					<button type="button" class="btn btn-default" onclick="Joomla.submitbutton('article.cancel')">
						<span class="icon-close"></span> <?php echo JText::_('JCANCEL') ?>
					</button>
				</div>
				<?php if ($params->get('save_history', 0)) : ?>
				<div class="btn-group">
					<?php echo str_replace(array('class="btn modal_jform_contenthistory', '<i class="icon-archive"></i>'),
					           array('class="btn modal_jform_contenthistory btn-default', '<i class="icon-file-zip"></i> '),
					           $this->form->getInput('contenthistory')); ?>
				</div>
				<?php endif; ?>
			</div>
			<fieldset>
				<ul class="nav nav-tabs">
					<li class="active"><a href="#editor" data-toggle="tab"><?php echo JText::_('COM_CONTENT_ARTICLE_CONTENT') ?></a></li>
					<?php if ($params->get('show_urls_images_frontend') ) : ?>
					<li><a href="#images" data-toggle="tab"><?php echo JText::_('COM_CONTENT_IMAGES_AND_URLS') ?></a></li>
					<?php endif; ?>
					<li><a href="#publishing" data-toggle="tab"><?php echo JText::_('COM_CONTENT_PUBLISHING') ?></a></li>
					<li><a href="#language" data-toggle="tab"><?php echo JText::_('JFIELD_LANGUAGE_LABEL') ?></a></li>
					<li><a href="#metadata" data-toggle="tab"><?php echo JText::_('COM_CONTENT_METADATA') ?></a></li>
				</ul>

				<div class="tab-content">
					<div class="tab-pane active" id="editor">
						<?php echo $this->form->renderField('title'); ?>

						<?php if (is_null($this->item->id)) : ?>
							<?php echo $this->form->renderField('alias'); ?>
						<?php endif; ?>

						<?php echo $this->form->getInput('articletext'); ?>
					</div>
					<?php if ($params->get('show_urls_images_frontend')): ?>
					<div class="tab-pane" id="images">
						<?php echo $this->form->renderField('image_intro', 'images'); ?>
						<?php echo $this->form->renderField('image_intro_alt', 'images'); ?>
						<?php echo $this->form->renderField('image_intro_caption', 'images'); ?>
						<?php echo $this->form->renderField('float_intro', 'images'); ?>
						<?php echo $this->form->renderField('image_fulltext', 'images'); ?>
						<?php echo $this->form->renderField('image_fulltext_alt', 'images'); ?>
						<?php echo $this->form->renderField('image_fulltext_caption', 'images'); ?>
						<?php echo $this->form->renderField('float_fulltext', 'images'); ?>
						<?php echo $this->form->renderField('urla', 'urls'); ?>
						<?php echo $this->form->renderField('urlatext', 'urls'); ?>
						<div class="control-group">
							<div class="controls">
								<?php echo $this->form->getInput('targeta', 'urls'); ?>
							</div>
						</div>
						<?php echo $this->form->renderField('urlb', 'urls'); ?>
						<?php echo $this->form->renderField('urlbtext', 'urls'); ?>
						<div class="control-group">
							<div class="controls">
								<?php echo $this->form->getInput('targetb', 'urls'); ?>
							</div>
						</div>
						<?php echo $this->form->renderField('urlc', 'urls'); ?>
						<?php echo $this->form->renderField('urlctext', 'urls'); ?>
						<div class="control-group">
							<div class="controls">
								<?php echo $this->form->getInput('targetc', 'urls'); ?>
							</div>
						</div>
					</div>
					<?php endif; ?>
					<div class="tab-pane" id="publishing">
						<?php echo $this->form->renderField('catid'); ?>
						<?php echo $this->form->renderField('tags'); ?>
						<?php if ($params->get('save_history', 0)) : ?>
							<?php echo $this->form->renderField('version_note'); ?>
						<?php endif; ?>
						<?php echo $this->form->renderField('created_by_alias'); ?>
						<?php if ($this->item->params->get('access-change')) : ?>
							<?php echo $this->form->renderField('state'); ?>
							<?php echo $this->form->renderField('featured'); ?>
							<?php echo $this->form->renderField('publish_up'); ?>
							<?php echo $this->form->renderField('publish_down'); ?>
						<?php endif; ?>
						<?php echo $this->form->renderField('access'); ?>
						<?php if (is_null($this->item->id)):?>
							<div class="control-group">
								<div class="control-label">
								</div>
								<div class="controls">
									<?php echo JText::_('COM_CONTENT_ORDERING'); ?>
								</div>
							</div>
						<?php endif; ?>
					</div>
					<div class="tab-pane" id="language">
						<?php echo $this->form->renderField('language'); ?>
					</div>
					<div class="tab-pane" id="metadata">
						<?php echo $this->form->renderField('metadesc'); ?>
						<?php echo $this->form->renderField('metakey'); ?>

						<input type="hidden" name="task" value="" />
						<input type="hidden" name="return" value="<?php echo $this->return_page; ?>" />
						<?php if ($this->params->get('enable_category', 0) == 1) :?>
						<input type="hidden" name="jform[catid]" value="<?php echo $this->params->get('catid', 1); ?>" />
						<?php endif; ?>
					</div>
				</div>
				<?php echo JHtml::_('form.token'); ?>
			</fieldset>
		</form>
	</div>
<?php endif; ?>

<?php
$global->setState('form.renderfields.format', null);
?>