<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

JHtml::_('behavior.core');
JHtml::_('behavior.keepalive');
JHtml::_('behavior.formvalidator');
?>
<div id="mailto-window">
	<div class="page-header">
		<h2><?php echo JText::_('COM_MAILTO_EMAIL_TO_A_FRIEND'); ?></h2>
	</div>

	<div class="mailto-close clearfix">
		<a class="btn btn-default btn-sm pull-right" href="javascript: void window.close()" title="<?php echo JText::_('COM_MAILTO_CLOSE_WINDOW'); ?>">
		 <span><?php echo JText::_('COM_MAILTO_CLOSE_WINDOW'); ?></span></a>
	</div>

	<form action="<?php echo JRoute::_('index.php?option=com_mailto&task=send'); ?>" id="mailtoForm" method="post" class="form-validate old-form">
		<?php foreach ($this->form->getFieldset('') as $field) : ?>
			<?php if ($field->hidden) : ?>
				<?php echo $field->input; ?>
			<?php elseif($field->type == 'Spacer') : ?>
				<div class="form-group">
					<?php echo $field->label; ?>
				</div>
			<?php else : ?>
				<?php VPFrameworkGlobal::getInstance()->setState('form.renderfields.format', array('labelClass' => 'control-label')); ?>
				<?php echo $field->renderField(); ?>
			<?php endif; ?>
		<?php endforeach; ?>
		<p>
			<button class="btn btn-base validate"><?php echo JText::_('COM_MAILTO_SEND'); ?></button>
			<button class="btn btn-default" onclick="window.close();return false;"><?php echo JText::_('COM_MAILTO_CANCEL'); ?></button>
		</p>
		<input type="hidden" name="layout" value="<?php echo htmlspecialchars($this->getLayout(), ENT_COMPAT, 'UTF-8'); ?>" />
		<input type="hidden" name="option" value="com_mailto" />
		<input type="hidden" name="task" value="send" />
		<input type="hidden" name="tmpl" value="component" />
		<input type="hidden" name="link" value="<?php echo $this->link; ?>" />
		<?php echo JHtml::_('form.token'); ?>
	</form>
</div>
