<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die('Restricted access');

$msgShown = false;
$success = false;
?>
<div class="vm-ajax-cart-popup">

	<?php if(!empty($this->products) && is_array($this->products)) : ?>
		<?php foreach($this->products as $product) : ?>
			<?php if($product->quantity > 0) : ?>
				<p><?php echo vmText::sprintf('COM_VIRTUEMART_CART_PRODUCT_ADDED', $product->product_name, $product->quantity) ?></p>
				<?php 
				$msgShown = true; 
				$success = true;
				?>
			<?php elseif(!empty($product->errorMsg)) : ?>
				<p class="hasError"><?php echo $product->errorMsg ?></p>
				<?php $msgShown = true; ?>
			<?php endif; ?>
		<?php endforeach; ?>
	<?php endif; ?>
	
	<?php if(!$msgShown) : ?>
		<p class="hasError"><?php echo vmText::_('COM_VIRTUEMART_CART_ERROR_NO_VALID_QUANTITY') ?></p>
	<?php endif; ?>
	
	<div class="ajax-popup-buttons">
		<a class="btn btn-default" href="<?php echo $this->continue_link ?>" target="_parent"><?php echo vmText::_('COM_VIRTUEMART_CONTINUE_SHOPPING') ?></a>
		<?php if($success) : ?>
			<a class="btn btn-base show-cart-button" href="<?php echo $this->cart_link ?>" target="_parent"><?php echo vmText::_('COM_VIRTUEMART_CART_SHOW') ?></a>
		<?php endif; ?>
	</div>

	<?php if(VmConfig::get('popup_rel', 1) && !empty($this->products) && is_array($this->products) && $success)
	{
		$limit = null;
		$count = 0;
		$i = 0;
		
		if(class_exists('plgSystemVPFrameworkHelper'))
		{
			$template = plgSystemVPFrameworkHelper::getTemplate();
			$limit   = $template->params->get('ajaxRelatedLimit', 3);
		}
		
		$product = reset($this->products);
		$customFieldsModel = VmModel::getModel('customfields');
		$product->customfields = $customFieldsModel->getCustomEmbeddedProductCustomFields($product->allIds, 'R');
		$customFieldsModel->displayProductCustomfieldFE($product, $product->customfields);
		
		if(!empty($product->customfields)) : ?>
			<div class="ajax-popup-products">
				<h5><?php echo vmText::_('COM_VIRTUEMART_RELATED_PRODUCTS_HEADING'); ?></h5>
				<div class="ajax-popup-products-cont">
					<div class="row row-condensed">
						<?php foreach($product->customfields as $field) : ?>
							<?php if(!empty($field->display)) : ?>
								<?php
								$i++;
								$count++;
								?>
								<div class="col-xs-4">
									<div class="ajax-popup-product">
										<?php echo $field->display ?>
									</div>
								</div>
								<?php if(!empty($limit) && $count == $limit) break; ?>
								<?php if($i == 3) : ?>
									<div class="clearfix"></div>
									<?php $i = 0; ?>
								<?php endif; ?>
							<?php endif; ?>
						<?php endforeach; ?>
					</div>
				</div>
			</div>
		<?php endif;
	} ?>
		
</div>