<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die('Restricted access');
?>
<div class="cart-select-shipment">

	<?php if (VmConfig::get('oncheckout_show_steps', 1)) : ?>
		<div class="checkoutStep" id="checkoutStep2"><?php echo vmText::_('COM_VIRTUEMART_USER_FORM_CART_STEP2') ?></div>
	<?php endif; ?>
	
	<?php if ($this->layoutName == 'default') : ?>
	
		<?php if ($this->cart->virtuemart_shipmentmethod_id) : ?>
			<h4 class="cart-method-title"><?php echo vmText::_('COM_VIRTUEMART_CART_SELECTED_SHIPMENT_SELECT') ?></h4>
		<?php else : ?>
			<h4 class="cart-method-title"><?php echo vmText::_('COM_VIRTUEMART_CART_SELECT_SHIPMENT') ?></h4>
		<?php endif; ?>
		
		<?php if ($this->found_shipment_method) : ?>
			<?php foreach ($this->shipments_shipment_rates as $shipment_shipment_rates) 
			{
				if (is_array($shipment_shipment_rates))
				{
					foreach($shipment_shipment_rates as $shipment_shipment_rate) : ?>
						<div class="shipment-rate clearfix"><?php echo $shipment_shipment_rate ?></div>
					<?php endforeach;
				}
			} ?>
			<?php if (VmConfig::get('cart_extraSafeBtn', false)) : ?>
				<div class="cart-method-submission-cont clearfix">
					<button name="updatecart" class="btn btn-default" type="submit" title="<?php echo vmText::_('COM_VIRTUEMART_SAVE'); ?>"<?php echo VmConfig::get('oncheckout_ajax', false) ? ' data-dynamic-update="1"' : ''; ?>>
						<i class="fa fa-check"></i> <?php echo vmText::_('COM_VIRTUEMART_SAVE'); ?>
					</button>
				</div>
			<?php endif; ?>
		<?php else : ?>
			<p class="bg-box bg-danger"><?php echo $this->shipment_not_found_text ?></p>
		<?php endif; ?>
		
	<?php else : ?>
	
		<form method="post" name="chooseShipmentRate" action="<?php echo JRoute::_('index.php'); ?>" class="form-validate">

			<?php if ($this->cart->virtuemart_shipmentmethod_id) : ?>
				<h2 class="cart-method-title"><?php echo vmText::_('COM_VIRTUEMART_CART_SELECTED_SHIPMENT_SELECT') ?></h2>
			<?php else : ?>
				<h2 class="cart-method-title"><?php echo vmText::_('COM_VIRTUEMART_CART_SELECT_SHIPMENT') ?></h2>
			<?php endif; ?>
			
			<?php if ($this->found_shipment_method) : ?>
				<?php foreach ($this->shipments_shipment_rates as $shipment_shipment_rates) 
				{
					if (is_array($shipment_shipment_rates))
					{
						foreach ($shipment_shipment_rates as $shipment_shipment_rate) : ?>
							<div class="shipment-rate clearfix"><?php echo $shipment_shipment_rate ?></div>
						<?php endforeach;
					}
				} ?>
				<div class="cart-method-submission-cont clearfix">
					 <button name="updatecart" class="btn btn-base btn-lg" type="submit" title="<?php echo vmText::_('COM_VIRTUEMART_SAVE'); ?>"><?php echo vmText::_('COM_VIRTUEMART_SAVE'); ?></button>
					 <button class="btn btn-default btn-lg" type="reset" onClick="window.location.href='<?php echo JRoute::_('index.php?option=com_virtuemart&view=cart&task=cancel'); ?>'" ><?php echo vmText::_('COM_VIRTUEMART_CANCEL'); ?></button>
				</div>
			<?php else : ?>
				<p class="bg-box bg-danger"><?php echo $this->shipment_not_found_text ?></p>
			<?php endif; ?>
		
			<input type="hidden" name="option" value="com_virtuemart"/>
			<input type="hidden" name="view" value="cart"/>
			<input type="hidden" name="task" value="updatecart"/>
			<input type="hidden" name="controller" value="cart"/>
		</form>
	
	<?php endif; ?>
</div>