<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die('Restricted access');

$template  = plgSystemVPFrameworkHelper::getTemplate();
$params    = $template->params;
$perRow    = VmConfig::get('manufacturer_per_row', 3);
$cellClass = 'col-sm-2 col-md-' . floor(12/$perRow);
?>
<section class="manufacturer-list">
	<?php if(!empty($this->manufacturers)) : ?>
		<div class="row row-condensed">
			<?php foreach($this->manufacturers as $manufacturer) : ?>
				<?php
				$image = !empty($manufacturer->images[0]) ? $manufacturer->images[0]->displayMediaThumb('class="img-responsive"', false) : '';
				if($params->get('vm_manufacturer_link') == 'products')
				{
					$url = JRoute::_('index.php?option=com_virtuemart&view=category&virtuemart_category_id=0&virtuemart_manufacturer_id=' . $manufacturer->virtuemart_manufacturer_id . '&cfm[0]=0');
				}
				else
				{
					$url = JRoute::_('index.php?option=com_virtuemart&view=manufacturer&virtuemart_manufacturer_id=' . $manufacturer->virtuemart_manufacturer_id);
				} ?>
				<div class="manufacturer <?php echo $cellClass ?>">
					<div class="manufacturer-inner">
						<div class="manufactuer-image-cont">
							<a href="<?php echo $url ?>" title="<?php echo $manufacturer->mf_name; ?>" class="hover-invert"><?php echo $image ?></a>
						</div>
						<div class="manufactuer-name-cont">
							<h2 class="manufactuer-name">
								<a href="<?php echo $url ?>" title="<?php echo $manufacturer->mf_name; ?>" class="hover-invert"><?php echo $manufacturer->mf_name; ?></a>
							</h2>
						</div>
					</div>
				</div>
			<?php endforeach; ?>
		</div>
	<?php endif; ?>
</section>