<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die('Restricted access');
?>
<table class="table table-condensed table-noborder" width="100%">
	<tbody>
		<tr>
			<td class="width24 field-name nowrap"><?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_PO_NUMBER') ?></td>
			<td><?php echo $this->orderdetails['details']['BT']->order_number; ?></td>
		</tr>
		<tr>
			<td class="field-name nowrap"><?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_PO_DATE') ?></td>
			<td><?php echo vmJsApi::date($this->orderdetails['details']['BT']->created_on, 'LC4', true); ?></td>
		</tr>
		<tr>
			<td class="field-name nowrap"><?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_PO_STATUS') ?></td>
			<td><?php echo $this->orderstatuses[$this->orderdetails['details']['BT']->order_status]; ?></td>
		</tr>
		<tr>
			<td class="field-name nowrap"><?php echo vmText::_('COM_VIRTUEMART_LAST_UPDATED') ?></td>
			<td><?php echo vmJsApi::date($this->orderdetails['details']['BT']->modified_on, 'LC4', true); ?></td>
		</tr>
		<tr>
			<td class="field-name nowrap"><?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_SHIPMENT_LBL') ?></td>
			<td><?php echo $this->shipment_name; ?></td>
		</tr>
		<tr>
			<td class="field-name nowrap"><?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_PAYMENT_LBL') ?></td>
			<td><?php echo $this->payment_name; ?></td>
		</tr>
		<tr>
			<td class="field-name nowrap"><?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_CUSTOMER_NOTE') ?></td>
			<td><?php echo $this->orderdetails['details']['BT']->customer_note; ?></td>
		</tr>
		<tr>
			<td class="field-name nowrap"><?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_TOTAL') ?></td>
			<td><?php echo $this->currency->priceDisplay($this->orderdetails['details']['BT']->order_total, $this->currency); ?></td>
		</tr>
	</tbody>
</table>
<div class="row">
	<?php $bt_class = !empty($this->shipmentfields['fields']) ? 'col-sm-6' : 'col-sm-12'; ?>
	<div class="<?php echo $bt_class ?>">
		<fieldset>
			<legend><?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_BILL_TO_LBL') ?></legend>
			<table class="table table-condensed table-noborder">
				<tbody>
					<?php foreach ($this->userfields['fields'] as $field) : ?>
						<?php if(!empty($field['value'])) : ?>
							<tr>
								<td class="width50 field-name"><?php echo $field['title'] ?></td>
								<td><?php echo $field['value'] ?></td>
							</tr>
						<?php endif; ?>
					<?php endforeach; ?>
				</tbody>
			</table>
		</fieldset>
	</div>
	<?php if(!empty($this->shipmentfields['fields'])) : ?>
		<div class="col-sm-6">
			<fieldset>
				<legend><?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_SHIP_TO_LBL') ?></legend>
				<table class="table table-condensed table-noborder">
					<tbody>
						<?php foreach ($this->shipmentfields['fields'] as $field) : ?>
							<?php if(!empty($field['value'])) : ?>
								<tr>
									<td class="width50 field-name"><?php echo $field['title'] ?></td>
									<td><?php echo $field['value'] ?></td>
								</tr>
							<?php endif; ?>
						<?php endforeach; ?>
					</tbody>
				</table>
			</fieldset>	
		</div>
	<?php endif; ?>
</div>