<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined ('_JEXEC') or die ('Restricted access');

$doc = JFactory::getDocument();
$align_center = false;

$review_editable = true;

if($this->allowRating || $this->allowReview || $this->showRating || $this->showReview) 
{
	$maxrating = (int) VmConfig::get('vm_maximum_rating_scale', 5);
	$ratingsShow = VmConfig::get('vm_num_ratings_show', 3);
	$showall = vRequest::getBool('showall', false);
	$hint = array();	
	for($i=1; $i<=$maxrating; $i++)
	{
		$hint[] = "'" . $i . " " . vmText::_('COM_VIRTUEMART_REVIEW_STARS') . "'";
	}	
	$hint = '[' . implode(',', $hint) . ']';
	
	if(!empty($this->rating_reviews)) 
	{
		foreach($this->rating_reviews as $review) 
		{
			if(($review->created_by == $this->user->id) && !$review->review_editable)
			{
				$review_editable = false;
			}
		}
	}
} 
if($this->allowRating || $this->allowReview)
{
	if($review_editable) 
	{
		$formActionURL = JRoute::_('index.php?option=com_virtuemart&view=productdetails&virtuemart_product_id=' . $this->product->virtuemart_product_id . '&virtuemart_category_id=' . $this->product->virtuemart_category_id, false); ?>
		<form method="post" action="<?php echo $formActionURL ?>" name="reviewForm" id="reviewform" role="form">
		
			<?php if($this->allowRating && $review_editable) : ?>
				<h4><?php echo vmText::_( 'COM_VIRTUEMART_WRITE_REVIEW' ); ?></h4>
				<?php if(empty($this->rating_reviews)) : ?>
					<h5><?php echo vmText::_('COM_VIRTUEMART_WRITE_FIRST_REVIEW') ?></h5>
				<?php endif; ?>
				<em class="text-muted">
					<?php echo vmText::_('COM_VIRTUEMART_RATING_FIRST_RATE') ?>
				</em>
				<div class="rate-product-cont form-group">
					<?php $rating = !empty($this->review->review_rating) ? $this->review->review_rating : 0; ?>
					<span id="rate" data-score="<?php echo $rating ?>"></span>
					<input type="hidden" name="vote" id="vote" value="<?php echo $rating ?>"/>
				</div>
				<?php
				$rateJS = "
        jQuery(document).ready(function($) {
          $('#rate').raty({
            score: function() {
              return $(this).data('score') ? $(this).data('score') : undefined;
            },
            numberMax: " . $maxrating . ",
            hints: " . $hint . ",
            starType: 'i',
            targetScore: '#vote',
            half: false
          });
        });
				";
				vmJsApi::addJScript('productEditRating', $rateJS);
				?>
			<?php endif; ?>

			<?php if ($this->allowReview && $review_editable) : ?>
				<div class="write-reviews">
					<?php
					$reviewJS = "
          function check_reviewform() {
            var form = document.getElementById('reviewform');
            var ausgewaehlt = false;
            if(form.comment.value.length < " . VmConfig::get('reviews_minimum_comment_length', 100) . ") {
               alert('" .addslashes(vmText::sprintf('COM_VIRTUEMART_REVIEW_ERR_COMMENT1_JS', VmConfig::get('reviews_minimum_comment_length', 100))) ."');
               return false;
            } else if(form.comment.value.length > " . VmConfig::get( 'reviews_maximum_comment_length', 2000 ) . ") {
               alert('" . addslashes(vmText::sprintf('COM_VIRTUEMART_REVIEW_ERR_COMMENT2_JS', VmConfig::get('reviews_maximum_comment_length', 2000))) . "');
               return false;
            } else {
             return true;
            }
          }
          function refresh_counter() {
            var form = document.getElementById('reviewform');
            form.counter.value= form.comment.value.length;
          }
          function resetReviewForm() {
          	jQuery('#reviewform')[0].reset();
          	jQuery('input#vote').val(jQuery(this).data('score'));
          	if(jQuery('#rate').length) {
              jQuery('#rate').raty({
                score: function() {
                  return jQuery(this).data('score');
                },
                numberMax: " . $maxrating . ",
                hints: " . $hint . ",
                starType: 'i',
                targetScore: '#vote',
                half: false
              });
            }
            return false;
          }
					";
					vmJsApi::addJScript('productAddReview', $reviewJS);
					?>
					<div class="form-group">
						<em class="text-muted"><?php echo vmText::sprintf('COM_VIRTUEMART_REVIEW_COMMENT', VmConfig::get('reviews_minimum_comment_length', 100), VmConfig::get('reviews_maximum_comment_length', 2000)); ?></em>
						<textarea class="virtuemart form-control" title="<?php echo vmText::_( 'COM_VIRTUEMART_WRITE_REVIEW' ) ?>" id="comment" onblur="refresh_counter();" onfocus="refresh_counter();" onkeyup="refresh_counter();" name="comment" rows="5" cols="60"><?php echo !empty($this->review->comment) ? $this->review->comment : ''; ?></textarea>
					</div>
					<div class="form-inline">
						<div class="form-group">
							<label class="sr-only"><?php echo vmText::_( 'COM_VIRTUEMART_REVIEW_COUNT' ) ?></label>
							<p class="form-control-static text-muted"><?php echo vmText::_( 'COM_VIRTUEMART_REVIEW_COUNT' ) ?></p>
						</div>
						<div class="form-group">
							<input type="text" class="form-control" value="0" size="4" name="counter" maxlength="4" readonly="readonly" />
						</div>
					</div>
				</div>
			<?php endif; ?>
			
			<?php if($review_editable && ($this->allowReview || $this->allowRating)) : ?>
				<div class="review-submit-buttons-cont">
					<?php if($review_editable && $this->allowReview) : ?>
						<button type="submit" class="btn btn-base btn-lg" onclick="return(check_reviewform());" title="<?php echo vmText::_('COM_VIRTUEMART_REVIEW_SUBMIT') ?>">
							<span><?php echo vmText::_('COM_VIRTUEMART_REVIEW_SUBMIT') ?></span>
						</button>
					<?php elseif($review_editable && $this->allowRating) : ?>
						<button type="submit" class="btn btn-base btn-lg" title="<?php echo vmText::_('COM_VIRTUEMART_REVIEW_SUBMIT') ?>">
							<span><?php echo vmText::_('COM_VIRTUEMART_REVIEW_SUBMIT') ?></span>
						</button>
					<?php endif; ?>
					<?php if ($this->allowReview && $review_editable) : ?>
						&nbsp;
						<button type="button" class="btn btn-default btn-lg" onclick="return resetReviewForm();" title="<?php echo vmText::_('COM_VIRTUEMART_RESET') ?>">
							<span><?php echo vmText::_('COM_VIRTUEMART_RESET') ?></span>
						</button>
					<?php endif; ?>
				</div>
			<?php endif; ?>
			
			<input type="hidden" name="virtuemart_product_id" value="<?php echo $this->product->virtuemart_product_id; ?>"/>
			<input type="hidden" name="option" value="com_virtuemart"/>
			<input type="hidden" name="virtuemart_category_id" value="<?php echo vRequest::getInt('virtuemart_category_id'); ?>"/>
			<input type="hidden" name="virtuemart_rating_review_id" value="0"/>
			<input type="hidden" name="task" value="review"/>
		</form>
		<hr />
	<?php
	}
	else
	{
		echo '<div class="review-posted">';
		echo '<p><strong>' .vmText::_( 'COM_VIRTUEMART_DEAR' ) . $this->user->name . ',</strong></p>';
		echo '<p>' . vmText::_( 'COM_VIRTUEMART_REVIEW_ALREADYDONE' ) . '</p>';
		echo '</div>';
	}
} ?>

<?php if ($this->showReview) : ?>
	<div class="list-of-reviews">
		<?php
		$i = 0;
		$reviews_published = 0;
		if ($this->rating_reviews) : ?>
			<h4><?php echo vmText::_('COM_VIRTUEMART_REVIEWS') ?></h4>
			<?php
			$rateJS = "
      jQuery(document).ready(function($) {
        $('.review-rating').raty({
          score: function() {
            return $(this).data('score') ? $(this).data('score') : undefined;
          },
          numberMax: " . $maxrating . ",
          hints: " . $hint . ",
          starType: 'i',
          readOnly: true,
          half: false
        });
      });
			";
			vmJsApi::addJScript('productReviewRating', $rateJS);
			?>
			<?php foreach ($this->rating_reviews as $review) : ?>
				<?php if($review->published) 
				{
					$reviews_published++;
					$reviewDate = new DateTime($review->created_on);
					?>
					<div class="customer-review-item" itemprop="review" itemscope itemtype="https://schema.org/Review">
						<p>
							<span itemprop="reviewRating" itemscope itemtype="https://schema.org/Rating">
								<meta itemprop="bestRating" content="<?php echo (int) $maxrating; ?>" />
								<meta itemprop="worstRating" content="1" />
								<meta itemprop="ratingValue" content="<?php echo (int) $review->review_rating; ?>" />
							</span>
							<span class="review-rating" data-score="<?php echo (int) $review->review_rating ?>"></span>
							<meta itemprop="datePublished" content="<?php echo $reviewDate->format('Y-m-d'); ?>" />
							<em class="text-muted"><?php echo JHtml::date($review->created_on, vmText::_('DATE_FORMAT_LC')); ?></em>
						</p>
						<blockquote>
							<p itemprop="reviewBody"><?php echo $review->comment; ?></p>
							<?php if($review->customer) : ?>
								<footer itemprop="author" itemscope itemtype="https://schema.org/Person"><span itemprop="name"><?php echo $review->customer ?></span></footer>
							<?php endif; ?>
						</blockquote>
					</div>
				<?php
				}
				$i++;
				if ($i == $ratingsShow && !$showall)
				{
					if ($reviews_published >= $ratingsShow)
					{
						$attribute = array('class'=> 'btn btn-default', 'title' => vmText::_('COM_VIRTUEMART_MORE_REVIEWS'));
						echo JHtml::link ($this->more_reviews, vmText::_('COM_VIRTUEMART_MORE_REVIEWS'), $attribute);
					}
					break;
				} ?>
			<?php endforeach; ?>
		<?php else : ?>
			<p class="no-reviews-msg bg-warning align-center"><?php echo vmText::_ ('COM_VIRTUEMART_NO_REVIEWS') ?></p>
			<?php $align_center = true; ?>
		<?php endif; ?>
	</div>
<?php endif; ?>
<?php
$user = JFactory::getUser();

if($user->guest && VmConfig::get('reviewMode', 'none') != 'none')
{
	$uri    = JUri::getInstance();
	$return = $uri->toString();
	echo '<p class="bg-box' . ($align_center ? ' align-center' : '') . '">';
	echo '<b>' . vmText::_('COM_VIRTUEMART_REVIEW_LOGIN') . '</b>';
	echo '&nbsp;';
	echo '<a data-modallogin="1" href="' . JRoute::_('index.php?option=com_users&view=login&return=' . base64_encode($return)) . '">' . JText::_('JLOGIN') . '</a>';
	echo '</p>';
}
?>