<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined ( '_JEXEC' ) or die ( 'Restricted access' );

JHtml::_('behavior.formvalidator');
?>
<section class="product-notify-page">
	<div class="page-header">
		<h1><?php echo vmText::_('COM_VIRTUEMART_CART_NOTIFY') ?></h1>
	</div>
	<form method="post" action="<?php echo JRoute::_('index.php?option=com_virtuemart&view=productdetails&virtuemart_product_id=' . $this->product->virtuemart_product_id . '&virtuemart_category_id=' . $this->product->virtuemart_category_id, false) ; ?>" name="notifyform" class="form-validate form-inline">
		<div class="notify-page-message">
			<p class="bg-box bg-info"><?php echo vmText::sprintf('COM_VIRTUEMART_CART_NOTIFY_DESC', $this->product->product_name); ?></p>
		</div>
		<div class="form-group">
			<label class="sr-only" for="notify_email"><?php echo JText::_('JGLOBAL_EMAIL') ?></label>
			<div class="input-group">
				<div class="input-group-addon">@</div>
				<input type="email" class="form-control" name="notify_email" id="notify_email" placeholder="<?php echo JText::_('JGLOBAL_EMAIL') ?>" value="<?php echo $this->user->email ?>" required="true"/>
			</div>
		</div>
		<button type="submit" class="btn btn-base validate" title="<?php echo vmText::_('COM_VIRTUEMART_CART_NOTIFY') ?>"><?php echo vmText::_('COM_VIRTUEMART_CART_NOTIFY') ?></button>
		<input type="hidden" name="virtuemart_product_id" value="<?php echo $this->product->virtuemart_product_id; ?>" />
		<input type="hidden" name="option" value="com_virtuemart" />
		<input type="hidden" name="virtuemart_category_id" value="<?php echo vRequest::getInt('virtuemart_category_id'); ?>" />
		<input type="hidden" name="virtuemart_user_id" value="<?php echo $this->user->id; ?>" />
		<input type="hidden" name="task" value="notifycustomer" />
		<input type="hidden" name="controller" value="productdetails" />
		<?php echo JHtml::_( 'form.token' ); ?>
	</form>
</section>
