<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

$_template       = plgSystemVPFrameworkHelper::getTemplate();
$params          = $_template->params;
$product         = $viewData['product'];
$isList          = isset($viewData['isList']) ? $viewData['isList'] : false;
$listMode        = isset($viewData['listMode']) ? $viewData['listMode'] : '';
$showDetailsLink = isset($viewData['showDetailsLink']) ? $viewData['showDetailsLink'] : false;
$askquestion_url = !empty($viewData['askquestion_url']) ? $viewData['askquestion_url'] : null;
$askquestion_btn = '';
$customClass     = $isList ? 'product-cart-variants hide' : 'product-cart-variants';
$stockhandle     = VmConfig::get('stockhandle_products', false) && $product->product_stockhandle ? $product->product_stockhandle : VmConfig::get('stockhandle', 'none');
$costPrice       = (float) $product->prices['costPrice'];
$salesPrice      = (float) $product->prices['salesPrice'];
$tmpPrice        = !empty($costPrice) && !empty($salesPrice);
$position        = 'addtocart';
$step            = isset($product->step_order_level) ? $product->step_order_level : 1;
$step            = (empty($step)) ? 1 : $step;
$btn_lg          = !$isList ? ' btn-lg btn-wide' : 'btn-md';
$addtoCartButton = '';
$noAddToCart     = ($product->product_discontinued && $params->get('vm_handle_discontinued_products', 0)) ? true : false;

// Overload new property to show separate ask question button in product details page.
$product->show_separate_ask_question = true;

if (!VmConfig::get('use_as_catalog', 0))
{
	if ($product->addToCartButton)
	{
		$addtoCartButton = $product->addToCartButton;
	} 
	else 
	{
		$addtoCartButton = shopFunctionsF::getAddToCartButton($product->orderable);
	}
	
	if (strpos($addtoCartButton, 'class=') !== false)
	{
		$addtoCartButton = str_replace('class="', 'class="btn btn-primary btn-addtocart ' . $btn_lg . ' ', $addtoCartButton);
	}
	else
	{
		$addtoCartButton = str_replace('type=', 'class="btn btn-primary btn-addtocart ' . $btn_lg . '" type=', $addtoCartButton);
	}
}

if (!empty($askquestion_url) && VmConfig::get('ask_question', 0))
{
	$askquestion_btn = '<button type="button" class="btn btn-nobg btn-lg btn-ask-question hasTooltip" data-iframe="modal" data-modaltitle="' . vmText::_('COM_VIRTUEMART_PRODUCT_ASK_QUESTION') . '" title="' . vmText::_('COM_VIRTUEMART_PRODUCT_ENQUIRY_LBL') . '" data-url="' . $askquestion_url . '"><i class="fa fa-question"></i></button>';
}

if (!VmConfig::get('use_as_catalog', 0)) : ?>
	<div class="addtocart-bar clearfix<?php echo $isList ? ' is-list' : ''; ?>">

		<?php if ($isList && VPFrameworkVM::hasCartAttribute($product)) : ?>
				<a href="<?php echo $product->link; ?>" title="<?php echo JText::_('TPL_VP_SMART_VIEW_OPTIONS') ?>" class="btn btn-primary btn-addtocart btn-options <?php echo $btn_lg ?>"><?php echo JText::_('TPL_VP_SMART_VIEW_OPTIONS') ?></a>
				
			<?php if ($isList && $listMode == 'list' && $showDetailsLink) : ?>
				<a href="<?php echo $product->link; ?>" title="<?php echo $product->product_name ?>" class="btn btn-invert btn-md hidden-xs product-details-button"><?php echo vmText::_('COM_VIRTUEMART_PRODUCT_DETAILS') ?></a>
			<?php endif; ?>

		<?php elseif ((property_exists($product, 'show_notify') && $product->show_notify) || (!property_exists($product, 'show_notify') && ($stockhandle == 'disableit' || $stockhandle == 'disableadd') && ($product->product_in_stock - $product->product_ordered) < 1)) : ?>
			<a href="<?php echo JRoute::_('index.php?option=com_virtuemart&view=productdetails&layout=notify&virtuemart_product_id=' . $product->virtuemart_product_id); ?>" class="btn btn-notify btn-info <?php echo trim($btn_lg) ?>" title="<?php echo vmText::_ ('COM_VIRTUEMART_CART_NOTIFY') ?>" target="_top" rel="no-follow"><?php echo vmText::_ ('COM_VIRTUEMART_CART_NOTIFY') ?></a><?php echo $askquestion_btn; ?>
			
			<?php if ($isList && $listMode == 'list' && $showDetailsLink) : ?>
				<a href="<?php echo $product->link; ?>" title="<?php echo $product->product_name ?>" class="btn btn-invert btn-md hidden-xs product-details-button"><?php echo vmText::_('COM_VIRTUEMART_PRODUCT_DETAILS') ?></a>
			<?php endif; ?>
			
		<?php else : ?>
			<?php if (!(VmConfig::get('askprice', true) && empty($tmpPrice)) && $product->orderable && !$noAddToCart) : ?>
				<?php
				$value = 1;
				
				if (isset($viewData['init']))
				{
					$value = $viewData['init'];
				}
				
				if (!empty($product->min_order_level))
				{
					$value = $product->min_order_level;
				}
				
				$step = 1;
				
				if (!empty($product->step_order_level))
				{
					$step = $product->step_order_level;
					
					if (!empty($value))
					{
						if ($value < $step)
						{
							$value = $step;
						}
						elseif ($value > $step)
						{
							$value = ceil($value / $step) * $step;
						}
					}
					
					if (empty($product->min_order_level) && !isset($viewData['init']))
					{
						$value = $step;
					}
				}
				
				$maxOrder = '';
				
				if (!empty($product->max_order_level))
				{
					$maxOrder = ' max="'.$product->max_order_level.'" ';
				}
				
				$hideClass = ($isList && !$params->get('vm_show_qty_list', 0)) || (!$isList && !$params->get('vm_show_qty', 0)) ? ' hide' : '';
				?>
				<span class="quantity-box-cont quantity-box<?php echo $hideClass ?>">
					<input type="text" class="form-control input-lg quantity-input js-recalculate" name="quantity[]" data-errStr="<?php echo vmText::_('COM_VIRTUEMART_WRONG_AMOUNT_ADDED')?>" value="<?php echo $value; ?>" init="<?php echo $value; ?>" step="<?php echo $step; ?>"<?php echo $maxOrder; ?> />
					<span class="quantity-controls-cont">
						<button type="button" class="quantity-controls quantity-plus"><i class="fa fa-angle-up"></i></button>
						<button type="button" class="quantity-controls quantity-minus"><i class="fa fa-angle-down"></i></button>
					</span>
				</span>
			<?php endif; ?>
			
			<?php if ($noAddToCart) : ?>
				<div class="text-danger"><strong><?php echo JText::_('PLG_SYSTEM_VPFRAMEWORK_PRODUCT_DISCONTINUED') ?></strong></div>
			<?php elseif (!(VmConfig::get('askprice', true) && empty($tmpPrice)) && !empty($addtoCartButton)) : ?>
				<span class="addtocart-button-cont">
					<?php echo $addtoCartButton; ?><?php echo $askquestion_btn; ?>
					<?php $product->show_separate_ask_question = false; ?>
				</span>
				<noscript><input type="hidden" name="task" value="add"/></noscript>
			<?php endif; ?>
			
			<?php if ($isList && $listMode == 'list' && $showDetailsLink) : ?>
				<a href="<?php echo $product->link; ?>" title="<?php echo $product->product_name ?>" class="btn btn-invert btn-md hidden-xs product-details-button"><?php echo vmText::_('COM_VIRTUEMART_PRODUCT_DETAILS') ?></a>
			<?php endif; ?>
			
		<?php endif; ?>
	</div>
<?php endif; ?>