<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VirtuePlanet Framework for Joomla!
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

class VirtueMartCustomFieldRenderer 
{
	static function renderCustomfieldsFE(&$product, &$customfields, $virtuemart_category_id)
	{
		static $calculator = false;
		static $currency = false;
		
		if (!$calculator)
		{
			if (!class_exists ('calculationHelper'))
			{
				require(VMPATH_ADMIN . '/helpers/calculationh.php');
			}
			
			$calculator = calculationHelper::getInstance ();
		}
		
		if (!$currency)
		{
			if (!class_exists ('CurrencyDisplay'))
			{
				require(VMPATH_ADMIN . '/helpers/currencydisplay.php');
			}
				
			$currency = CurrencyDisplay::getInstance ();
		}
		
		if (!class_exists ('vmCustomPlugin'))
		{
			require(VMPATH_PLUGINLIBS . '/vmcustomplugin.php');
		}

		$selectList = array();

		$dynChilds = 1;

		foreach ($customfields as $k => $customfield)
		{
			$customfield->display = !isset($customfield->display) ? '' : $customfield->display;
			$calculator->_product = $product;
			
			// If custom field plugin
			if ($customfield->field_type == 'E')
			{
				JPluginHelper::importPlugin ('vmcustom');
				
				if (version_compare(JVERSION, '4.0.0', 'ge'))
				{
					$results = JFactory::getApplication()->triggerEvent('plgVmOnDisplayProductFEVM3', array(&$product, &$customfields[$k]));
				}
				else
				{
					$results = JEventDispatcher::getInstance()->trigger('plgVmOnDisplayProductFEVM3', array(&$product, &$customfields[$k]));
				}
				
				continue;
			}

			$fieldname = 'field[' . $product->virtuemart_product_id . '][' . $customfield->virtuemart_customfield_id . '][customfield_value]';
			$customProductDataName = 'customProductData[' . $product->virtuemart_product_id . '][' . $customfield->virtuemart_custom_id . ']';

			//This is a kind of fallback, setting default of custom if there is no value of the productcustom
			$customfield->customfield_value = empty($customfield->customfield_value) ? $customfield->custom_value : $customfield->customfield_value;

			$type = $customfield->field_type;

			$idTag = 'customProductData_' . (int)$product->virtuemart_product_id . '_' . $customfield->virtuemart_customfield_id;
			$idTag = VmHtml::ensureUniqueId($idTag);

			$emptyOption = new stdClass();
			$emptyOption->text = vmText::_ ('COM_VIRTUEMART_ADDTOCART_CHOOSE_VARIANT');
			$emptyOption->value = 0;
			
			switch ($type)
			{
				case 'C':

					$html = '';

					$dropdowns = array();

					if (isset($customfield->options->{$product->virtuemart_product_id}))
					{
						$productSelection = (array) $customfield->options->{$product->virtuemart_product_id};
					}
					else
					{
						$productSelection = false;
					}
					
					$stockhandle = VmConfig::get('stockhandle_products', false) && property_exists($product, 'product_stockhandle') && $product->product_stockhandle ? $product->product_stockhandle : VmConfig::get('stockhandle', 'none');
					
					$db = JFactory::getDbo();
					$query = $db->getQuery(true);
					
					$query->select($db->quoteName('virtuemart_product_id'))
						->from($db->quoteName('#__virtuemart_products'))
						->where($db->quoteName('product_parent_id') . ' = ' . (int) $customfield->virtuemart_product_id)
						->where($db->quoteName('published') . ' = 1');
					
					if ($stockhandle == 'disableit_children')
					{
						$query->where($db->quoteName('product_in_stock') . ' - ' . $db->quoteName('product_ordered') . ' > 0');
					}
					
					$db->setQuery($query);
					$available = $db->loadColumn();
					
					// Add selected product
					// array_unshift($available, $product->virtuemart_product_id);
					
					// Add parent product
					array_unshift($available, $customfield->virtuemart_product_id);

					foreach ($customfield->options as $product_id => $variants)
					{
						if (!in_array($product_id, $available))
						{
							vmdebug('$customfield->options Product to ignore, continue ', $product_id);
							continue;
						}
						
						$variants = (array) $variants;

						foreach ($variants as $varKey => $variant)
						{
							$dropdowns[$varKey] = (!isset($dropdowns[$varKey]) || !is_array($dropdowns[$varKey])) ? array() : $dropdowns[$varKey];

							if (!in_array($variant, $dropdowns[$varKey]))
							{
								if ($varKey == 0 || !$productSelection)
								{
									$dropdowns[$varKey][] = $variant;
								}
								elseif ($varKey > 0 && $productSelection[$varKey - 1] == $variants[$varKey - 1])
								{
									$break = false;
									
									for($h = 1; $h <= $varKey; $h++)
									{
										if ($productSelection[$h-1] != $variants[$h-1])
										{
											$break = true;
										}
									}
									
									if (!$break)
									{
										$dropdowns[$varKey][] = $variant;
									}
								}
							}
						}
					}

					$view = vRequest::getCmd('view', 'productdetails');

					$class      = 'vm-chzn-select';
					$selectType = 'select.genericlist';

					if (!empty($customfield->selectType))
					{
						$selectType = 'select.radiolist';
						$class = '';
						$dom = '';
					}
					else
					{
						vmJsApi::chosenDropDowns();
						$dom = 'select';
					}

					$attribs = array('class'=> $class . ' cvselection no-vm-bind', 'style' => 'min-width:70px;');
					
					$attribs['data-reload'] = '1';
					$view = 'productdetails';
					
					if (VmConfig::get('jdynupdate', true)) {
						$view = vRequest::getCmd('view', 'productdetails');
						
						if ($view == 'productdetails' || ($customfield->browseajax && $view == 'category')) {
							$attribs['data-dynamic-update'] = '1';
							unset($attribs['data-reload']);
						} else {
							$view = 'productdetails';
						}
					}
					
					foreach ($customfield->selectoptions as $optKey => $soption)
					{
						$options = array();
						$selected = false;
						
						if (isset($dropdowns[$optKey]))
						{
							foreach ($dropdowns[$optKey] as $i => $elem)
							{
								$elem = trim((string)$elem);
								$text = $elem;

								if ($soption->clabel != '' && in_array($soption->voption, VirtueMartModelCustomfields::$dimensions))
								{
									$rd = $soption->clabel;
									
									if (is_numeric($rd) && is_numeric($elem))
									{
										$text = number_format(round((float) $elem, (int)$rd), $rd);
									}
								} 
								elseif ($soption->voption === 'clabels' && $soption->clabel != '')
								{
									$text = vmText::_($elem);
								}

								if (empty($elem))
								{
									$text = vmText::_('COM_VIRTUEMART_LIST_EMPTY_OPTION');
								}
								
								$o = new stdClass();
								$o->value = $elem;
								$o->text = $text;
								$options[] = $o;

								if ($productSelection && $productSelection[$optKey] == $elem)
								{
									$selected = $elem;
								}
							}
						}

						if (empty($selected))
						{
							$product->orderable=false;
						}
						
						$idTagK = $idTag . 'cvard' . $optKey;
						
						if ($customfield->showlabels)
						{
							if (in_array($soption->voption, VirtueMartModelCustomfields::$dimensions))
							{
								$soption->slabel = vmText::_('COM_VIRTUEMART_'.strtoupper($soption->voption));
							}
							elseif (!empty($soption->clabel) && !in_array($soption->voption, VirtueMartModelCustomfields::$dimensions))
							{
								$soption->slabel = vmText::_($soption->clabel);
							}
							
							if (isset($soption->slabel))
							{
								$html .= '<span class="vm-cmv-label" >' . $soption->slabel . '</span>';
							}
						}

						$attribs['data-cvsel'] = 'field' . $customfield->virtuemart_customfield_id;
						
						$fname = $fieldname. '[' . $optKey . ']';
						
						if ($selectType === 'select.radiolist' && version_compare(JVERSION, '4.0.0', 'ge'))
						{
							$html .= self::renderRedioList($options, $fname, $attribs, 'value', 'text', $selected, $idTagK);
						}
						else
						{
							$html .= JHtml::_($selectType, $options, $fname, $attribs , "value", "text", $selected, $idTagK);
						}
					}

					$Itemid = vRequest::getInt('Itemid','');
					$Itemid = !empty($Itemid) ? '&Itemid='.$Itemid : '';

					//create array for js
					$jsArray = array();

					$url = '';

					foreach ($customfield->options as $product_id => $variants)
					{
						if (!empty($ignore) && in_array($product_id, $ignore))
						{
							continue;
						}

						$url = JRoute::_('index.php?option=com_virtuemart&view=' . $view . '&virtuemart_category_id=' . $virtuemart_category_id . '&virtuemart_product_id=' . $product_id . $Itemid, false);
						
						$jsArray[] = '["'.$url.'","' . implode('","', $variants) . '"]';
					}

					vmJsApi::addJScript('cvfind', false, false, false, false);

					$jsVariants = implode(',', $jsArray);

					$selector = $dom . '[data-cvsel="' . $attribs['data-cvsel'] . '"]';
					$hash = md5($selector);
					
					$BrowserNewState = $view != 'productdetails' ? 'Virtuemart.setBrowserState = false;' : 'Virtuemart.setBrowserState = true;';
					
					$js  = "(function($){";
					$js .= "$(function(){";
					$js .= $BrowserNewState;
					$js .= "$(document).on('init.cvfind', function(){";
					$js .= "$('" . $selector . "').off('change',Virtuemart.cvFind).on('change',{variants:[" . $jsVariants . "]},Virtuemart.cvFind);";
					$js .= "});";
					$js .= "$(document).trigger('init.cvfind');";
					$js .= "$('body').on('updateVirtueMartProductDetail', function(){";
					$js .= "$(document).trigger('init.cvfind');";
					$js .= "});";
					$js .= "$(document).on('vm.category.page.loaded', function(){";
					$js .= "$(document).trigger('init.cvfind');";
					$js .= "});";
					$js .= "});";
					$js .= "})(jQuery);";
					
					vmJsApi::addJScript('cvselvars' . $hash, $js, false, false, false, $hash);

					// Now we need just the JS to reload the correct product
					$customfield->display = $html;
					
					break;

				case 'A':

					$html = '';

					$productModel = VmModel::getModel ('product');

					//Note by Jeremy Magne (Daycounts) 2013-08-31
					//Previously the the product model is loaded but we need to ensure the correct product id is set because the getUncategorizedChildren does not get the product id as parameter.
					//In case the product model was previously loaded, by a related product for example, this would generate wrong uncategorized children list
					$productModel->setId($customfield->virtuemart_product_id);

					$uncatChildren = $productModel->getUncategorizedChildren($customfield->withParent);

					$options = array();

					$selected = vRequest::getInt ('virtuemart_product_id', 0);
					$selectedFound = false;
					
					$view = 'productdetails';
					$attribs['data-reload'] = '1';
					
					if (VmConfig::get ('jdynupdate', true))
					{
						$view = vRequest::getCmd('view', 'productdetails');
						
						if ($view == 'productdetails' || ($customfield->browseajax and $view == 'category'))
						{
							$attribs['data-dynamic-update'] = '1';
							unset($attribs['data-reload']);
						}
						else
						{
							$view = 'productdetails';
						}
					}
					
					$Itemid = vRequest::getInt('Itemid', '');
					
					if (!empty($Itemid))
					{
						$Itemid = '&Itemid='.$Itemid;
					}
					
					if (!$customfield->withParent)
					{
						$options[0] = $emptyOption;
						$options[0]->value = JRoute::_ ('index.php?option=com_virtuemart&view=' . $view . '&virtuemart_category_id=' . $virtuemart_category_id . '&virtuemart_product_id=' . $customfield->virtuemart_product_id, false);
					}

					$parentStock = 0;
					
					if ($uncatChildren)
					{
						foreach ($uncatChildren as $child)
						{
							$productChild = $productModel->getProduct((int)$child, true);
							
							if (empty($productChild))
							{
								continue;
							}
							
							if (!isset($productChild->{$customfield->customfield_value}))
							{
								vmdebug('The child has no value at index ' . $customfield->customfield_value, $customfield,$child);
								continue;
							}
							
							$available = $productChild->product_in_stock - $productChild->product_ordered;
							
							if (VmConfig::get('stockhandle','none') == 'disableit_children' && $available <= 0)
							{
								continue;
							}
							
							$parentStock += $available;
							
							$priceStr = '';
							
							if ($customfield->wPrice)
							{
								$productPrices = $calculator->getProductPrices($productChild);
								$priceStr =  ' (' . $currency->priceDisplay($productPrices['salesPrice']) . ')';
							}
							
							$options[] = array('value' => JRoute::_('index.php?option=com_virtuemart&view=' . $view . '&virtuemart_category_id=' . $virtuemart_category_id . '&virtuemart_product_id=' . $productChild->virtuemart_product_id, false), 'text' => $productChild->{$customfield->customfield_value} . $priceStr);

							if ($selected==$child)
							{
								$selectedFound = true;
								vmdebug($customfield->virtuemart_product_id.' $selectedFound by vRequest '.$selected);
							}
						}
					}

					if (!$selectedFound)
					{
						$pos = array_search($customfield->virtuemart_product_id, $product->allIds);
						
						if (isset($product->allIds[$pos - 1]))
						{
							$selected = $product->allIds[$pos - 1];
						}
						elseif (isset($product->allIds[$pos]))
						{
							$selected = $product->allIds[$pos];
						}
						else
						{
							$selected = $customfield->virtuemart_product_id;
						}
					}

					$url = 'index.php?option=com_virtuemart&view=' . $view . '&virtuemart_category_id=' . $virtuemart_category_id . '&virtuemart_product_id=' . $selected;
					
					$attribs['option.key.toHtml'] = false;
					$attribs['id'] = $idTag;
					
					$och = '';
					
					if (!empty($attribs['data-reload']))
					{
						$och = ' onchange="window.top.location.href=this.options[this.selectedIndex].value" data-reload=1';
						unset($attribs['data-reload']);
					}
					else
					{
						$och = ' data-dynamic-update="1"';
						unset($attribs['data-dynamic-update']);
					}
					
					$attribs['list.attr'] = 'size="1" class="vm-chzn-select no-vm-bind avselection"' . $och;
					$attribs['list.translate'] = false;
					$attribs['option.key'] = 'value';
					$attribs['option.text'] = 'text';
					$attribs['list.select'] = JRoute::_($url, false);
					
					$html .= JHtml::_ ('select.genericlist', $options, $fieldname, $attribs);

					//vmJsApi::chosenDropDowns();

					if ($customfield->parentOrderable==0)
					{
						if ($product->virtuemart_product_id==$customfield->virtuemart_product_id)
						{
							$product->orderable = false;
							$product->product_in_stock = $parentStock;
						}
					}

					$dynChilds++;
					$customfield->display = $html;
					
					vmJsApi::addJScript('cvfind');
					
					$BrowserNewState = $view != 'productdetails' ? 'Virtuemart.setBrowserState = false;' : 'Virtuemart.setBrowserState = true;';

					$js  = "(function($){";
					$js .= "$(function(){";
					$js .= $BrowserNewState;
					$js .= "$(document).on('init.avselect', function(){";
					$js .= "$('select.avselection').off('change',Virtuemart.avFind).on('change',{},Virtuemart.avFind);";
					$js .= "});";
					$js .= "$(document).trigger('init.avselect');";
					$js .= "$('body').on('updateVirtueMartProductDetail', function(){";
					$js .= "$(document).trigger('init.avselect');";
					$js .= "});";
					$js .= "$(document).on('vm.category.page.loaded', function(){";
					$js .= "$(document).trigger('init.avselect');";
					$js .= "});";
					$js .= "});";
					$js .= "})(jQuery);";
					
					vmJsApi::addJScript('avselvars', $js, true);

					break;

				/*Date variant*/
				case 'D':

					$customfield->custom_value = empty($customfield->custom_value) ? 'LC2' : $customfield->custom_value;
					
					// Customer selects date
					if ($customfield->is_input)
					{
						$customfield->display =  '<span class="product_custom_date">' . vmJsApi::jDate($customfield->customfield_value, $customProductDataName) . '</span>';
					}
					else
					{
						$customfield->display =  '<span class="product_custom_date">' . vmJsApi::date($customfield->customfield_value, $customfield->custom_value, true) . '</span>';
					}

					break;

				/* text area or editor No vmText, only displayed in BE */
				case 'X':
				
					$customfield->display = version_compare(vmVersion::$RELEASE, '4.0.0', 'ge') ? $customfield->customfield_params : $customfield->customfield_value;
					
					break;

				case 'Y':

					$customfield->display =  $customfield->customfield_value;

					break;

				/* string or integer */
				case 'B':
				case 'S':
				case 'M':
				case 'PB':
					
					if (VmConfig::get('hideEmptyCustomfields',false) && empty($customfield->customfield_value))
					{
						break;
					}
					
					if (isset($customfield->selectType))
					{
						if (empty($customfield->selectType))
						{
							$selectType = 'select.genericlist';
							
							if (!empty($customfield->is_input))
							{
								vmJsApi::chosenDropDowns();
								$class = 'class="vm-chzn-select"';
							}
						}
						else
						{
							$selectType = 'select.radiolist';
							$class = '';
						}
					}
					else
					{
						if ($type== 'M')
						{
							$selectType = 'select.radiolist';
							$class = '';
						}
						else
						{
							$selectType = 'select.genericlist';
							
							if (!empty($customfield->is_input))
							{
								vmJsApi::chosenDropDowns();
								$class = 'class="vm-chzn-select"';
							}
						}
					}

					if ($customfield->is_list && $customfield->is_list != 2)
					{
						if (!empty($customfield->is_input))
						{
							$options = array();

							if ($customfield->addEmpty)
							{
								$options[0] = $emptyOption;
							}

							$values = explode (';', $customfield->custom_value);

							foreach ($values as $key => $val)
							{
								if ($val == 0 && $customfield->addEmpty)
								{
									continue;
								}
								
								if ($type == 'M')
								{
									$tmp = array('value' => $val, 'text' => VirtueMartModelCustomfields::displayCustomMedia ($val, 'product', $customfield->width, $customfield->height));
									$options[] = (object)$tmp;
								}
								else
								{
									$options[] = array('value' => $val, 'text' => vmText::_($val));
								}
							}

							$currentValue = $customfield->customfield_value;
							
							if ($selectType === 'select.radiolist' && version_compare(JVERSION, '4.0.0', 'ge'))
							{
								$customfield->display = self::renderRedioList($options, $customProductDataName . '[' . $customfield->virtuemart_customfield_id . ']', $class, 'value', 'text', $currentValue, $idTag);
							}
							else
							{
								$customfield->display = JHtml::_($selectType, $options, $customProductDataName . '[' . $customfield->virtuemart_customfield_id . ']', $class, 'value', 'text', $currentValue, $idTag);
							}
						} 
						else
						{
							if ($type == 'M')
							{
								$customfield->display =  VirtueMartModelCustomfields::displayCustomMedia($customfield->customfield_value, 'product', $customfield->width, $customfield->height);
							}
							else
							{
								$customfield->display =  vmText::_($customfield->customfield_value);
							}
						}
					}
					else
					{
						if (!empty($customfield->is_input))
						{
							if (!isset($selectList[$customfield->virtuemart_custom_id]))
							{
								$selectList[$customfield->virtuemart_custom_id] = $k;
								
								if ($customfield->addEmpty)
								{
									if (empty($customfields[$selectList[$customfield->virtuemart_custom_id]]->options))
									{
										$customfields[$selectList[$customfield->virtuemart_custom_id]]->options[0] = $emptyOption;
										$customfields[$selectList[$customfield->virtuemart_custom_id]]->options[0]->virtuemart_customfield_id = $emptyOption->value;
									}
								}

								$tmpField = clone($customfield);
								$tmpField->options = null;
								$customfield->options[$customfield->virtuemart_customfield_id] = $tmpField;

								$customfield->customProductDataName = $customProductDataName;
							}
							else
							{
								$customfields[$selectList[$customfield->virtuemart_custom_id]]->options[$customfield->virtuemart_customfield_id] = $customfield;
								unset($customfields[$k]);
							}

							$default = reset($customfields[$selectList[$customfield->virtuemart_custom_id]]->options);
							
							foreach ($customfields[$selectList[$customfield->virtuemart_custom_id]]->options as &$productCustom)
							{
								$productCustom->customfield_price = !isset($productCustom->customfield_price) ? 0.0 : $productCustom->customfield_price;
								$productCustom->customfield_value = !isset($productCustom->customfield_value) ? '' : $productCustom->customfield_value;

								if (method_exists('VirtueMartModelCustomfields', 'renderCustomfieldPrice'))
								{
									$price = VirtueMartModelCustomfields::renderCustomfieldPrice($productCustom, $product, $calculator);
								}
								else
								{
									$price = VirtueMartModelCustomfields::_getCustomPrice($productCustom->customfield_price, $currency, $calculator);
								}
								
								if ($type == 'M')
								{
									$productCustom->customfield_value = !isset($productCustom->customfield_value) ? '' : $productCustom->customfield_value;
									$productCustom->text = VirtueMartModelCustomfields::displayCustomMedia($productCustom->customfield_value, 'product', $customfield->width, $customfield->height) . ' ' . $price;
								}
								elseif($type == 'PB')
								{
									$productB = VmModel::getModel('product')->getProduct($productCustom->bundle_product_id);
									/*$images[0] = $productB->virtuemart_media_id[0];
									$width = isset($customfield->width)? $customfield->width : VmConfig::get('img_width', 0);
									$height = isset($customfield->height)? $customfield->height : VmConfig::get('img_height', 0);
									$thumb = '';
									//if(!empty($width) or !empty($height)){
										$thumb = VirtueMartModelCustomfields::displayCustomMedia($images[0], 'product', $width, $height ).' ';
									//}*/
									$productCustom->text = /*$thumb . ' ' . */$productB->product_name . ' ' . $price;
								}
								else
								{
									$trValue = vmText::_($productCustom->customfield_value);
									
									if ($productCustom->customfield_value != $trValue && strpos($trValue, '%1') !== false)
									{
										$productCustom->text = vmText::sprintf($productCustom->customfield_value, $price);
									}
									else
									{
										$productCustom->text = $trValue . ' ' . $price;
									}
								}
							}

							if ($selectType === 'select.radiolist' && version_compare(JVERSION, '4.0.0', 'ge'))
							{
								$customfields[$selectList[$customfield->virtuemart_custom_id]]->display = self::renderRedioList($customfields[$selectList[$customfield->virtuemart_custom_id]]->options, $customfields[$selectList[$customfield->virtuemart_custom_id]]->customProductDataName, $class, 'virtuemart_customfield_id', 'text', $default->customfield_value, $idTag);
							}
							else
							{
								$customfields[$selectList[$customfield->virtuemart_custom_id]]->display = JHtml::_($selectType, $customfields[$selectList[$customfield->virtuemart_custom_id]]->options, $customfields[$selectList[$customfield->virtuemart_custom_id]]->customProductDataName, $class, 'virtuemart_customfield_id', 'text', $default->customfield_value, $idTag);
							}
						}
						else
						{
							if ($type == 'M')
							{
								$customfield->display = VirtueMartModelCustomfields::displayCustomMedia ($customfield->customfield_value,'product',$customfield->width,$customfield->height);
							}
							else
							{
								$customfield->display = vmText::_($customfield->customfield_value);
							}
						}
					}

					break;

				// Property
				case 'P':

					$attr = $customfield->customfield_value;
					$lkey = 'COM_VIRTUEMART_' . strtoupper($customfield->customfield_value) . '_FE';
					
					$trValue = vmText::_($lkey);
					$options[] = array('value' => 'product_length', 'text' => vmText::_ ('COM_VIRTUEMART_PRODUCT_LENGTH'));
					$options[] = array('value' => 'product_width', 'text' => vmText::_ ('COM_VIRTUEMART_PRODUCT_WIDTH'));
					$options[] = array('value' => 'product_height', 'text' => vmText::_ ('COM_VIRTUEMART_PRODUCT_HEIGHT'));
					$options[] = array('value' => 'product_weight', 'text' => vmText::_ ('COM_VIRTUEMART_PRODUCT_WEIGHT'));

					$dim = '';

					if ($attr == 'product_length' || $attr == 'product_width' || $attr == 'product_height')
					{
						$dim = $product->product_lwh_uom;
					}
					elseif ($attr == 'product_weight')
					{
						$dim = $product->product_weight_uom;
					}
					
					if (!isset($product->$attr))
					{
						logInfo('customfield.php: case P, property ' . $attr . ' does not exists. virtuemart_custom_id: ' . $customfield->virtuemart_custom_id);
						break;
					}
					
					$val= $product->$attr;

					if (!empty($customfield->round) && $customfield->round != 0)
					{
						if (!isset($customfield->digits))
						{
							$customfield->digits = $customfield->round;
						}
						elseif (empty($customfield->digits))
						{
							$customfield->digits = 0;
						}
						
						if (method_exists($currency, 'getFormattedNumber'))
						{
							$val = $currency->getFormattedNumber($val, $customfield->digits);
						}
						else
						{
							$val = round($val, $customfield->digits);
						}
					}
					
					if ($lkey != $trValue && strpos($trValue, ' %1') !== false)
					{
						$customfield->display = vmText::sprintf($customfield->customfield_value, $val, $dim);
					}
					elseif ($lkey != $trValue)
					{
						$customfield->display = $trValue . ' ' . $val;
					}
					else
					{
						$customfield->display = vmText::_('COM_VIRTUEMART_' . strtoupper($customfield->customfield_value)) . ' ' . $val . $dim;
					}

					break;

				case 'Z':
				
					if (empty($customfield->customfield_value))
					{
						break;
					}
					
					$html = '';

					$db = JFactory::getDBO();
					$query = $db->getQuery(true);
					
					$query->select('*')
					      ->from($db->quoteName('#__virtuemart_categories_' . VmConfig::$vmlang) . 'AS l')
					      ->join('INNER', $db->quoteName('#__virtuemart_categories') . 'AS c ON c.' . $db->quoteName('virtuemart_category_id') . ' = l.' . $db->quoteName('virtuemart_category_id'))
					      ->where($db->quoteName('published') . ' = 1')
					      ->where('l.' . $db->quoteName('virtuemart_category_id') . ' = ' . (int) $customfield->customfield_value);

					$db->setQuery($query);
					$category = $db->loadObject();
					
					if (!empty($category) && !empty($category->virtuemart_category_id))
					{
						$query->clear()
						      ->select($db->quoteName('virtuemart_media_id'))
						      ->from($db->quoteName('#__virtuemart_category_medias'))
						      ->where($db->quoteName('virtuemart_category_id') . ' = ' . (int) $category->virtuemart_category_id);
						
						$db->setQuery($query);
						
						$thumb = '';
						
						if ($media_id = $db->loadResult())
						{
							$thumb = VirtueMartModelCustomfields::displayCustomMedia ($media_id,'category',$customfield->width,$customfield->height);
						}
						
						$customfield->display = JHtml::link(JRoute::_ ('index.php?option=com_virtuemart&view=category&virtuemart_category_id=' . $category->virtuemart_category_id), $thumb . ' ' . $category->category_name, array('title' => $category->category_name, 'target'=>'_blank'));
					}

					break;

				case 'RC':
				
					$pModel = VmModel::getModel('product');
					
					if (!empty($customfield->customfield_value))
					{
						$prodIds = explode(',', $customfield->customfield_value);
						
						foreach ($prodIds as $pId)
						{
							$related = $pModel->getProduct((int)$pId, true, $customfield->wPrice, true, 1);
							
							if (!$related)
							{
								vmError('Custom related Product with id '.$pId.' not found');
								continue;
							}
							
							$customfield->display .= VirtueMartCustomFieldRenderer::renderRelatedProduct($customfield, $related);
						}
					}

					break;

				case 'R':

					if (empty($customfield->customfield_value))
					{
						$customfield->display = 'customfield related product has no value';
						break;
					}

					$pModel = VmModel::getModel('product');
					$related = $pModel->getProduct((int)$customfield->customfield_value, true, $customfield->wPrice, true, 1);

					if (!$related) break;

					$thumb = '';
					
					if ($customfield->wImage)
					{
						if (!empty($related->virtuemart_media_id[0]))
						{
							$thumb = VirtueMartModelCustomfields::displayCustomMedia($related->virtuemart_media_id[0], 'product', $customfield->width, $customfield->height) . ' ';
						}
						else
						{
							$thumb = VirtueMartModelCustomfields::displayCustomMedia(0, 'product', $customfield->width, $customfield->height) . ' ';
						}
					}
					
					if (!empty($customfield->waddtocart))
					{
						if (!empty($related->customfields))
						{
							$customfieldsModel = VmModel::getModel ('customfields');
							
							if (empty($customfield->from))
							{
								$customfield->from = $related->virtuemart_product_id;
								$customfieldsModel->displayProductCustomfieldFE($related, $related->customfields);
							}
							elseif ($customfield->from!=$related->virtuemart_product_id)
							{
								$customfieldsModel->displayProductCustomfieldFE($related, $related->customfields);
							}
						}
						
						$isCustomVariant = false;
						
						if (!empty($related->customfields))
						{
							foreach ($related->customfields as $custom)
							{
								if ($custom->field_type == 'C' and $custom->virtuemart_product_id != (int)$customfield->customfield_value)
								{
									$isCustomVariant = $custom;
								}
								
								if (!empty($custom->layout_pos))
								{
									$related->customfieldsSorted[$custom->layout_pos][] = $custom;
								}
								else
								{
									$related->customfieldsSorted['normal'][] = $custom;
								}
								
								unset($related->customfields);
							}
						}
					}

					$customfield->display = shopFunctionsF::renderVmSubLayout('related', array('customfield' => $customfield, 'related' => $related, 'thumb' => $thumb));
					break;
			}

			$viewData['customfields'][$k] = $customfield;
		}
	}

	static function renderCustomfieldsCart($product, $html, $trigger)
	{
		if (isset($product->param))
		{
			vmTrace('param found, seek and destroy');
			return false;
		}

		if (!class_exists ('shopFunctionsF'))
		{
			require(VMPATH_SITE . '/helpers/shopfunctionsf.php');
		}

		$row = 0;
		$variantmods = isset($product->customProductData) ? $product->customProductData : $product->product_attribute;
		$app = JFactory::getApplication();

		if (empty($product->customfields))
		{
			$productDB = VmModel::getModel('product')->getProduct($product->virtuemart_product_id);
			
			if ($productDB && isset($productDB->customfields))
			{
				$product->customfields = $productDB->customfields;
			}
			else
			{
				$product->customfields = array();
			}
		}
		
		if (!is_array($variantmods))
		{
			$variantmods = json_decode($variantmods, true);
		}

		$productCustoms = array();
		
		foreach ((array)$product->customfields as $prodcustom)
		{
			// We just add the customfields to be shown in the cart to the variantmods
			if (is_object($prodcustom))
			{
				if (($prodcustom->is_cart_attribute || $prodcustom->is_input) && (($app->isClient('site') && !$prodcustom->is_hidden && !$prodcustom->admin_only) || ($app->isClient('administrator') && !$prodcustom->is_hidden)))
				{
					if (!isset($variantmods[$prodcustom->virtuemart_custom_id]) || (is_array($variantmods[$prodcustom->virtuemart_custom_id]) && !isset($variantmods[$prodcustom->virtuemart_custom_id][$prodcustom->virtuemart_customfield_id])) )
					{
						$variantmods[$prodcustom->virtuemart_custom_id][$prodcustom->virtuemart_customfield_id] = $prodcustom->virtuemart_customfield_id;
					}
				}
				
				$productCustoms[$prodcustom->virtuemart_customfield_id] = $prodcustom;
			}
		}

		foreach ((array)$variantmods as $custom_id => $customfield_ids)
		{
			if (!is_array($customfield_ids))
			{
				$customfield_ids = array($customfield_ids => false);
			}

			foreach ($customfield_ids as $customfield_id => $params)
			{
				if (empty($productCustoms) || !isset($productCustoms[$customfield_id]))
				{
					vmdebug('displayProductCustomfieldSelected continue');
					continue;
				}
				
				$productCustom = $productCustoms[$customfield_id];
				
				// vmdebug('displayProductCustomfieldSelected ',$customfield_id,$productCustom);
				// The stored result in vm2.0.14 looks like this {"48":{"textinput":{"comment":"test"}}}
				// and now {"32":[{"invala":"100"}]}
				if (!empty($productCustom))
				{
					$otag = ' <span class="product-field-type-' . $productCustom->field_type . '">';
					$tmp = '';

					if ($productCustom->field_type == "E")
					{
						if (!class_exists ('vmCustomPlugin'))
						{
							require(VMPATH_PLUGINLIBS . '/vmcustomplugin.php');
						}

						JPluginHelper::importPlugin ('vmcustom');
						
						if (version_compare(JVERSION, '4.0.0', 'ge'))
						{
							JFactory::getApplication()->triggerEvent($trigger . 'VM3', array(&$product, &$productCustom, &$tmp));
						}
						else
						{
							JEventDispatcher::getInstance()->trigger($trigger . 'VM3', array(&$product, &$productCustom, &$tmp));
						}
					}
					else 
					{
						$value = '';

						if ($productCustom->field_type == 'G')
						{
							$db = JFactory::getDBO ();
							$db->setQuery ('SELECT  `product_name` FROM `#__virtuemart_products_' . VmConfig::$vmlang . '` WHERE virtuemart_product_id = ' . (int)$productCustom->customfield_value);
							$child = $db->loadObject ();
							$value = $child->product_name;
						}
						elseif ($productCustom->field_type == 'M')
						{
							$customFieldModel = VmModel::getModel('customfields');
							$value = $customFieldModel->displayCustomMedia ($productCustom->customfield_value,'product',$productCustom->width,$productCustom->height,VirtueMartModelCustomfields::$useAbsUrls);
						}
						elseif ($productCustom->field_type == 'S')
						{
							if ($productCustom->is_list and $productCustom->is_input)
							{
								if ($productCustom->is_list == 2)
								{
									$value = vmText::_($productCustom->customfield_value);
								}
								else
								{
									$value = vmText::_($params);
								}
							}
							else
							{
								$value = vmText::_($productCustom->customfield_value);
							}
						}
						elseif ($productCustom->field_type == 'PB')
						{
							$productDB = VmModel::getModel('product')->getProduct($productCustom->bundle_product_id);
							// we could even add the price here
							$value = $productDB->product_name . ' (' . $productDB->product_sku . ') - ' . $productDB->virtuemart_product_id;
						}
						elseif ($productCustom->field_type == 'A')
						{
							if (!property_exists($product, $productCustom->customfield_value))
							{
								$productDB = VmModel::getModel('product')->getProduct($product->virtuemart_product_id);
								
								if ($productDB)
								{
									$attr = $productCustom->customfield_value;
									$product->$attr = $productDB->$attr;
								}
							}
							
							$value = vmText::_($product->{$productCustom->customfield_value});
						}
						elseif ($productCustom->field_type == 'C')
						{
							foreach ($productCustom->options->{$product->virtuemart_product_id} as $k => $option)
							{
								$value .= '<span> ';
								
								if (!empty($productCustom->selectoptions[$k]->clabel) && in_array($productCustom->selectoptions[$k]->voption,VirtueMartModelCustomfields::$dimensions))
								{
									$value .= vmText::_('COM_VIRTUEMART_'.$productCustom->selectoptions[$k]->voption);
									$rd = $productCustom->selectoptions[$k]->clabel;
									
									if (is_numeric($rd) && is_numeric($option))
									{
										$value .= ' ' . number_format(round((float) $option, (int) $rd), $rd);
									}
								}
								else
								{
									if (!empty($productCustom->selectoptions[$k]->clabel))
									{
										$value .= vmText::_($productCustom->selectoptions[$k]->clabel);
									}

									$value .= ' ' . vmText::_($option) . ' ';
								}
								
								$value .= '</span><br>';
							}
							
							$value = trim($value);
							
							if (!empty($value))
							{
								$html .= $otag.$value.'</span><br />';
							}

							continue;
						}
						elseif ($productCustom->field_type == 'D')
						{
							if ($productCustom->is_input)
							{
								$value = $params;
							}
							else
							{
								$value = $productCustom->customfield_value;
							}
						}
						else
						{
							$value = vmText::_($productCustom->customfield_value);
						}
						
						$trTitle = vmText::_($productCustom->custom_title);
						$tmp = '';

						if ($productCustom->custom_title != $trTitle && strpos($trTitle, '%1') !== false)
						{
							$tmp .= vmText::sprintf($productCustom->custom_title, $value);
						}
						else
						{
							$tmp .= $trTitle . ' ' . $value;
						}
					}
					
					if (!empty($tmp))
					{
						$html .= $otag . $tmp . '</span><br />';
					}
				}
				else
				{
					foreach ((array)$customfield_id as $key => $value)
					{
						$html .= '<br/ >Couldnt find customfield' . ($key ? '<span>' . $key . ' </span>' : '') . $value;
					}
					
					vmdebug ('customFieldDisplay, $productCustom is EMPTY '.$customfield_id);
				}
			}
		}

		return $html . '</div>';
	}
	
	
	/**
	 * Generates an HTML radio list.
	 *
	 * @param   array    $data       An array of objects
	 * @param   string   $name       The value of the HTML name attribute
	 * @param   string   $attribs    Additional HTML attributes for the `<select>` tag
	 * @param   mixed    $optKey     The key that is selected
	 * @param   string   $optText    The name of the object variable for the option value
	 * @param   string   $selected   The name of the object variable for the option text
	 * @param   boolean  $idtag      Value of the field id or null by default
	 * @param   boolean  $translate  True if options will be translated
	 *
	 * @return  string  HTML for the select list
	 */
	protected static function renderRedioList($data, $name, $attribs = null, $optKey = 'value', $optText = 'text', $selected = null, $idtag = false, $translate = false)
	{
		if (is_array($attribs))
		{
			$attribs = Joomla\Utilities\ArrayHelper::toString($attribs);
		}

		$id_text = $idtag ?: $name;

		$html = '<div class="controls">';

		foreach ($data as $obj)
		{
			$k = $obj->$optKey;
			$t = $translate ? JText::_($obj->$optText) : $obj->$optText;
			$id = (isset($obj->id) ? $obj->id : null);

			$extra = '';
			$id = $id ? $obj->id : $id_text . $k;

			if (is_array($selected))
			{
				foreach ($selected as $val)
				{
					$k2 = is_object($val) ? $val->$optKey : $val;

					if ($k == $k2)
					{
						$extra .= ' selected="selected" ';
						break;
					}
				}
			}
			else
			{
				$extra .= ((string) $k === (string) $selected ? ' checked="checked" ' : '');
			}

			$html .= "\n\t" . '<label for="' . $id . '" id="' . $id . '-lbl" class="radio">';
			$html .= "\n\t\n\t" . '<input type="radio" name="' . $name . '" id="' . $id . '" value="' . $k . '" ' . $extra
				. $attribs . ' />' . $t;
			$html .= "\n\t" . '</label>';
		}

		$html .= "\n";
		$html .= '</div>';
		$html .= "\n";

		return $html;
	}
}

