<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

// Load required validation scripts
VPFrameworkVM::addValidator();

$doc      = JFactory::getDocument();
$template = plgSystemVPFrameworkHelper::getTemplate();

$js = '
    jQuery(document).ready(function($){
        $(".vendor-toolbar .store-manage-link > a").addClass("btn btn-default");
        $(".vendor-toolbar .add-new-product-link > a").addClass("btn btn-success");
    });
';

$doc->addScriptDeclaration($js);
?>
<section class="vm-user-edit-page">
	<div class="page-header">
		<h1><?php echo $this->page_title ?></h1>
	</div>
	<div class="vm-user-login-cont">
		<?php echo shopFunctionsF::getLoginForm(false); ?>
	</div>
	<?php if(empty($this->userDetails->virtuemart_user_id)) : ?>
		<h2 class="sub-heading"><?php echo vmText::_('COM_VIRTUEMART_YOUR_ACCOUNT_REG') ?></h2>
	<?php endif; ?>
	<form method="post" id="adminForm" name="userForm" action="<?php echo JRoute::_('index.php?option=com_virtuemart&view=user',$this->useXHTML,$this->useSSL) ?>" class="form-validate form-horizontal old-form">
		<?php if(!empty($this->userDetails->virtuemart_user_id)) 
		{
			$tabarray = array();
			$tabarray['shopper'] = 'COM_VIRTUEMART_SHOPPER_FORM_LBL';
			if($this->userDetails->user_is_vendor)
			{
				if(!empty($this->add_product_link)) : ?>
					<div class="vendor-toolbar">
						<span class="store-manage-link">
							<?php echo $this->manage_link ?>
						</span>
						<span class="add-new-product-link">
							<?php echo $this->add_product_link; ?>
						</span>
					</div>
				<?php endif;
				$tabarray['vendor'] = 'COM_VIRTUEMART_VENDOR';
			}

			if (!empty($this->shipto))
			{
				$tabarray['shipto'] = 'COM_VIRTUEMART_USER_FORM_ADD_SHIPTO_LBL';
			}
			if (($_ordcnt = count($this->orderlist)) > 0)
			{
				$tabarray['orderlist'] = 'COM_VIRTUEMART_YOUR_ORDERS';
			} ?>
			
			<div role="tabpanel">
				<ul class="nav nav-tabs" role="tablist">
					<?php foreach($tabarray as $type => $name) : ?>
						<li role="presentation"<?php echo ($type == 'shopper') ? ' class="active"' : ''; ?>>
							<a href="#tab-id-<?php echo $type ?>" aria-controls="tab-id-<?php echo $type ?>" role="tab" data-toggle="tab"><?php echo vmText::_($name) ?></a>
						</li>
					<?php endforeach; ?>
				</ul>
				<div class="tab-content">
					<?php foreach($tabarray as $type => $name) : ?>
						<div role="tabpanel" class="tab-pane fade<?php echo ($type == 'shopper') ? ' in active' : ''; ?>" id="tab-id-<?php echo $type ?>">
							<?php echo $this->loadTemplate($type) ?>
						</div>
					<?php endforeach; ?>
				</div>
			</div>
			<?php
		}
		else
		{
			echo $this->loadTemplate('shopper');
		} ?>
		
		<?php if($this->userDetails->user_is_vendor) : ?>
			<?php if (VmConfig::get('reg_captcha')) : ?>
				<div class="form-group">
					<div class="col-sm-offset-3 col-sm-9">
						<?php echo $this->captcha; ?>
					</div>
				</div>
			<?php endif; ?>
			<div class="vm-user-form-buttons-cont">
				<div class="form-group">
					<div class="col-sm-offset-3 col-sm-9">
						<button class="btn btn-base btn-lg" type="submit" onclick="javascript:return myValidator(userForm, true);"><?php echo $this->button_lbl ?></button>
						&nbsp;
						<button class="btn btn-default btn-lg" type="reset" onclick="window.location.href='<?php echo JRoute::_('index.php?option=com_virtuemart&view=user&task=cancel', false); ?>'"><?php echo vmText::_('COM_VIRTUEMART_CANCEL'); ?></button>
					</div>
				</div>
			</div>
		<?php endif; ?>
			
		<input type="hidden" name="option" value="com_virtuemart" />
		<input type="hidden" name="controller" value="user" />
		<?php echo JHtml::_('form.token'); ?>
	</form>
</section>
